/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.McpJsonMapperUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.test.StepVerifier;

public abstract class AbstractMcpAsyncClientTests {
    private static final String ECHO_TEST_MESSAGE = "Hello MCP Spring AI!";

    protected abstract McpClientTransport createMcpTransport();

    protected Duration getRequestTimeout() {
        return Duration.ofSeconds(14L);
    }

    protected Duration getInitializationTimeout() {
        return Duration.ofSeconds(2L);
    }

    McpAsyncClient client(McpClientTransport transport) {
        return this.client(transport, Function.identity());
    }

    McpAsyncClient client(McpClientTransport transport, Function<McpClient.AsyncSpec, McpClient.AsyncSpec> customizer) {
        AtomicReference client = new AtomicReference();
        Assertions.assertThatCode(() -> {
            McpClient.AsyncSpec builder = McpClient.async((McpClientTransport)transport).requestTimeout(this.getRequestTimeout()).initializationTimeout(this.getInitializationTimeout()).sampling(req -> Mono.just((Object)new McpSchema.CreateMessageResult(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Oh, hi!"), "modelId", McpSchema.CreateMessageResult.StopReason.END_TURN))).capabilities(McpSchema.ClientCapabilities.builder().roots(Boolean.valueOf(true)).sampling().build());
            builder = (McpClient.AsyncSpec)customizer.apply(builder);
            client.set(builder.build());
        }).doesNotThrowAnyException();
        return (McpAsyncClient)client.get();
    }

    void withClient(McpClientTransport transport, Consumer<McpAsyncClient> c) {
        this.withClient(transport, Function.identity(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withClient(McpClientTransport transport, Function<McpClient.AsyncSpec, McpClient.AsyncSpec> customizer, Consumer<McpAsyncClient> c) {
        McpAsyncClient client = this.client(transport, customizer);
        try {
            c.accept(client);
        }
        finally {
            StepVerifier.create((Publisher)client.closeGracefully()).expectComplete().verify(Duration.ofSeconds(10L));
        }
    }

    <T> void verifyNotificationSucceedsWithImplicitInitialization(Function<McpAsyncClient, Mono<T>> operation, String action) {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)((Publisher)operation.apply((McpAsyncClient)mcpAsyncClient))).verifyComplete());
    }

    <T> void verifyCallSucceedsWithImplicitInitialization(Function<McpAsyncClient, Mono<T>> operation, String action) {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)((Publisher)operation.apply((McpAsyncClient)mcpAsyncClient))).expectNextCount(1L).verifyComplete());
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.async(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpClient.async((McpClientTransport)this.createMcpTransport()).requestTimeout(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Request timeout must not be null");
    }

    @Test
    void testListToolsWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listTools(McpSchema.FIRST_PAGE), "listing tools");
    }

    @Test
    void testListTools() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listTools(McpSchema.FIRST_PAGE))).consumeNextWith(result -> {
            ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
            McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
            Assertions.assertThat((String)firstTool.name()).isNotNull();
            Assertions.assertThat((String)firstTool.description()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testListAllTools() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listTools())).consumeNextWith(result -> {
            ((ListAssert)Assertions.assertThat((List)result.tools()).isNotNull()).isNotEmpty();
            McpSchema.Tool firstTool = (McpSchema.Tool)result.tools().get(0);
            Assertions.assertThat((String)firstTool.name()).isNotNull();
            Assertions.assertThat((String)firstTool.description()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testListAllToolsReturnsImmutableList() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listTools())).consumeNextWith(result -> {
            Assertions.assertThat((List)result.tools()).isNotNull();
            Assertions.assertThatThrownBy(() -> result.tools().add(McpSchema.Tool.builder().name("test").title("test").inputSchema(McpJsonMapperUtils.JSON_MAPPER, "{\"type\":\"object\"}").build())).isInstanceOf(UnsupportedOperationException.class);
        }).verifyComplete());
    }

    @Test
    void testPingWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.ping(), "pinging the server");
    }

    @Test
    void testPing() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.ping())).expectNextCount(1L).verifyComplete());
    }

    @Test
    void testCallToolWithoutInitialization() {
        McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", ECHO_TEST_MESSAGE));
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.callTool(callToolRequest), "calling tools");
    }

    @Test
    void testCallTool() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.CallToolRequest callToolRequest = new McpSchema.CallToolRequest("echo", Map.of("message", ECHO_TEST_MESSAGE));
            StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.callTool(callToolRequest))).consumeNextWith(callToolResult -> ((ObjectAssert)Assertions.assertThat((Object)callToolResult).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
                Assertions.assertThat((List)result.content()).isNotNull();
                Assertions.assertThat((Boolean)result.isError()).isNull();
            }})).verifyComplete();
        });
    }

    @Test
    void testCallToolWithInvalidTool() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.CallToolRequest invalidRequest = new McpSchema.CallToolRequest("nonexistent_tool", Map.of("message", ECHO_TEST_MESSAGE));
            StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.callTool(invalidRequest))).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(McpError.class)).hasMessage("Unknown tool: nonexistent_tool")).verify();
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"success", "error", "debug"})
    void testCallToolWithMessageAnnotations(String messageType) {
        McpClientTransport transport = this.createMcpTransport();
        this.withClient(transport, mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.callTool(new McpSchema.CallToolRequest("annotatedMessage", Map.of("messageType", messageType, "includeImage", true))))).consumeNextWith(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Boolean)result.isError()).isNotEqualTo(true);
            Assertions.assertThat((List)result.content()).isNotEmpty();
            Assertions.assertThat((List)result.content()).allSatisfy(content -> {
                block4 : switch (content.type()) {
                    case "text": {
                        McpSchema.TextContent textContent = (McpSchema.TextContent)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.TextContent.class, (Object)content);
                        Assertions.assertThat((String)textContent.text()).isNotEmpty();
                        Assertions.assertThat((Object)textContent.annotations()).isNotNull();
                        switch (messageType) {
                            case "error": {
                                Assertions.assertThat((Double)textContent.annotations().priority()).isEqualTo(1.0);
                                Assertions.assertThat((List)textContent.annotations().audience()).containsOnly((Object[])new McpSchema.Role[]{McpSchema.Role.USER, McpSchema.Role.ASSISTANT});
                                break block4;
                            }
                            case "success": {
                                Assertions.assertThat((Double)textContent.annotations().priority()).isEqualTo(0.7);
                                Assertions.assertThat((List)textContent.annotations().audience()).containsExactly((Object[])new McpSchema.Role[]{McpSchema.Role.USER});
                                break block4;
                            }
                            case "debug": {
                                Assertions.assertThat((Double)textContent.annotations().priority()).isEqualTo(0.3);
                                Assertions.assertThat((List)textContent.annotations().audience()).containsExactly((Object[])new McpSchema.Role[]{McpSchema.Role.ASSISTANT});
                                break block4;
                            }
                        }
                        throw new IllegalStateException("Unexpected value: " + content.type());
                    }
                    case "image": {
                        McpSchema.ImageContent imageContent = (McpSchema.ImageContent)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.ImageContent.class, (Object)content);
                        Assertions.assertThat((String)imageContent.data()).isNotEmpty();
                        Assertions.assertThat((Object)imageContent.annotations()).isNotNull();
                        Assertions.assertThat((Double)imageContent.annotations().priority()).isEqualTo(0.5);
                        Assertions.assertThat((List)imageContent.annotations().audience()).containsExactly((Object[])new McpSchema.Role[]{McpSchema.Role.USER});
                        break;
                    }
                    default: {
                        Assertions.fail((String)("Unexpected content type: " + content.type()));
                    }
                }
            });
        }).verifyComplete());
    }

    @Test
    void testListResourcesWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listResources(McpSchema.FIRST_PAGE), "listing resources");
    }

    @Test
    void testListResources() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResources(McpSchema.FIRST_PAGE))).consumeNextWith(resources -> ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.resources()).isNotNull();
            if (!result.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                Assertions.assertThat((String)firstResource.uri()).isNotNull();
                Assertions.assertThat((String)firstResource.name()).isNotNull();
            }
        }})).verifyComplete());
    }

    @Test
    void testListAllResources() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResources())).consumeNextWith(resources -> ((ObjectAssert)Assertions.assertThat((Object)resources).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.resources()).isNotNull();
            if (!result.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)result.resources().get(0);
                Assertions.assertThat((String)firstResource.uri()).isNotNull();
                Assertions.assertThat((String)firstResource.name()).isNotNull();
            }
        }})).verifyComplete());
    }

    @Test
    void testListAllResourcesReturnsImmutableList() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResources())).consumeNextWith(result -> {
            Assertions.assertThat((List)result.resources()).isNotNull();
            Assertions.assertThatThrownBy(() -> result.resources().add(McpSchema.Resource.builder().uri("test://uri").name("test").build())).isInstanceOf(UnsupportedOperationException.class);
        }).verifyComplete());
    }

    @Test
    void testMcpAsyncClientState() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> Assertions.assertThat((Object)mcpAsyncClient).isNotNull());
    }

    @Test
    void testListPromptsWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listPrompts(McpSchema.FIRST_PAGE), "listing prompts");
    }

    @Test
    void testListPrompts() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listPrompts(McpSchema.FIRST_PAGE))).consumeNextWith(prompts -> ((ObjectAssert)Assertions.assertThat((Object)prompts).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.prompts()).isNotNull();
            if (!result.prompts().isEmpty()) {
                McpSchema.Prompt firstPrompt = (McpSchema.Prompt)result.prompts().get(0);
                Assertions.assertThat((String)firstPrompt.name()).isNotNull();
                Assertions.assertThat((String)firstPrompt.description()).isNotNull();
            }
        }})).verifyComplete());
    }

    @Test
    void testListAllPrompts() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listPrompts())).consumeNextWith(prompts -> ((ObjectAssert)Assertions.assertThat((Object)prompts).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.prompts()).isNotNull();
            if (!result.prompts().isEmpty()) {
                McpSchema.Prompt firstPrompt = (McpSchema.Prompt)result.prompts().get(0);
                Assertions.assertThat((String)firstPrompt.name()).isNotNull();
                Assertions.assertThat((String)firstPrompt.description()).isNotNull();
            }
        }})).verifyComplete());
    }

    @Test
    void testListAllPromptsReturnsImmutableList() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listPrompts())).consumeNextWith(result -> {
            Assertions.assertThat((List)result.prompts()).isNotNull();
            Assertions.assertThatThrownBy(() -> result.prompts().add(new McpSchema.Prompt("test", "test", "test", null))).isInstanceOf(UnsupportedOperationException.class);
        }).verifyComplete());
    }

    @Test
    void testGetPromptWithoutInitialization() {
        McpSchema.GetPromptRequest request = new McpSchema.GetPromptRequest("simple_prompt", Map.of());
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.getPrompt(request), "getting prompts");
    }

    @Test
    void testGetPrompt() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.getPrompt(new McpSchema.GetPromptRequest("simple_prompt", Map.of())))).consumeNextWith(prompt -> ((ObjectAssert)Assertions.assertThat((Object)prompt).isNotNull()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((List)result.messages()).isNotEmpty();
            Assertions.assertThat((List)result.messages()).hasSize(1);
        }})).verifyComplete());
    }

    @Test
    void testRootsListChangedWithoutInitialization() {
        this.verifyNotificationSucceedsWithImplicitInitialization(client -> client.rootsListChangedNotification(), "sending roots list changed notification");
    }

    @Test
    void testRootsListChanged() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.rootsListChangedNotification())).verifyComplete());
    }

    @Test
    void testInitializeWithRootsListProviders() {
        this.withClient(this.createMcpTransport(), builder -> builder.roots(new McpSchema.Root[]{new McpSchema.Root("file:///test/path", "test-root")}), client -> StepVerifier.create((Publisher)client.initialize().then(client.closeGracefully())).verifyComplete());
    }

    @Test
    void testAddRoot() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.Root newRoot = new McpSchema.Root("file:///new/test/path", "new-test-root");
            StepVerifier.create((Publisher)mcpAsyncClient.addRoot(newRoot)).verifyComplete();
        });
    }

    @Test
    void testAddRootWithNullValue() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.addRoot(null)).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("Root must not be null")).verify());
    }

    @Test
    void testRemoveRoot() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> {
            McpSchema.Root root = new McpSchema.Root("file:///test/path/to/remove", "root-to-remove");
            StepVerifier.create((Publisher)mcpAsyncClient.addRoot(root)).verifyComplete();
            StepVerifier.create((Publisher)mcpAsyncClient.removeRoot(root.uri())).verifyComplete();
        });
    }

    @Test
    void testRemoveNonExistentRoot() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.removeRoot("nonexistent-uri")).consumeErrorWith(e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalStateException.class)).hasMessage("Root with uri 'nonexistent-uri' not found")).verify());
    }

    @Test
    void testReadResource() {
        this.withClient(this.createMcpTransport(), client -> {
            Flux resources = client.initialize().then(client.listResources(null)).flatMapMany(r -> Flux.fromIterable((Iterable)r.resources())).flatMap(r -> client.readResource(r));
            StepVerifier.create((Publisher)resources).recordWith(ArrayList::new).consumeRecordedWith(readResourceResults -> {
                for (McpSchema.ReadResourceResult result : readResourceResults) {
                    Assertions.assertThat((Object)result).isNotNull();
                    ((ListAssert)Assertions.assertThat((List)result.contents()).isNotNull()).isNotEmpty();
                    block9: for (McpSchema.ResourceContents content : result.contents()) {
                        McpSchema.TextResourceContents textContent;
                        Assertions.assertThat((Object)content).isNotNull();
                        ((AbstractStringAssert)Assertions.assertThat((String)content.uri()).isNotNull()).isNotEmpty();
                        ((AbstractStringAssert)Assertions.assertThat((String)content.mimeType()).isNotNull()).isNotEmpty();
                        switch (content.mimeType()) {
                            case "text/plain": {
                                textContent = (McpSchema.TextResourceContents)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.TextResourceContents.class, (Object)content);
                                ((AbstractStringAssert)Assertions.assertThat((String)textContent.text()).isNotNull()).isNotEmpty();
                                Assertions.assertThat((String)textContent.uri()).isNotEmpty();
                                continue block9;
                            }
                            case "application/octet-stream": {
                                McpSchema.BlobResourceContents blobContent = (McpSchema.BlobResourceContents)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.BlobResourceContents.class, (Object)content);
                                ((AbstractStringAssert)Assertions.assertThat((String)blobContent.blob()).isNotNull()).isNotEmpty();
                                ((AbstractStringAssert)Assertions.assertThat((String)blobContent.uri()).isNotNull()).isNotEmpty();
                                Assertions.assertThat((String)blobContent.blob()).matches((CharSequence)"^[A-Za-z0-9+/]*={0,2}$");
                                continue block9;
                            }
                        }
                        if (content instanceof McpSchema.TextResourceContents) {
                            textContent = (McpSchema.TextResourceContents)content;
                            Assertions.assertThat((String)textContent.text()).isNotNull();
                            continue;
                        }
                        if (!(content instanceof McpSchema.BlobResourceContents)) continue;
                        McpSchema.BlobResourceContents blobContent = (McpSchema.BlobResourceContents)content;
                        Assertions.assertThat((String)blobContent.blob()).isNotNull();
                    }
                }
            }).expectNextCount(10L).verifyComplete();
        });
    }

    @Test
    void testListResourceTemplatesWithoutInitialization() {
        this.verifyCallSucceedsWithImplicitInitialization(client -> client.listResourceTemplates(McpSchema.FIRST_PAGE), "listing resource templates");
    }

    @Test
    void testListResourceTemplates() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResourceTemplates(McpSchema.FIRST_PAGE))).consumeNextWith(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testListAllResourceTemplates() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResourceTemplates())).consumeNextWith(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testListAllResourceTemplatesReturnsImmutableList() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().then(mcpAsyncClient.listResourceTemplates())).consumeNextWith(result -> {
            Assertions.assertThat((List)result.resourceTemplates()).isNotNull();
            Assertions.assertThatThrownBy(() -> result.resourceTemplates().add(new McpSchema.ResourceTemplate("test://template", "test", "test", null, null, null))).isInstanceOf(UnsupportedOperationException.class);
        }).verifyComplete());
    }

    void testResourceSubscription() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.listResources()).consumeNextWith(resources -> {
            if (!resources.resources().isEmpty()) {
                McpSchema.Resource firstResource = (McpSchema.Resource)resources.resources().get(0);
                StepVerifier.create((Publisher)mcpAsyncClient.subscribeResource(new McpSchema.SubscribeRequest(firstResource.uri()))).verifyComplete();
                StepVerifier.create((Publisher)mcpAsyncClient.unsubscribeResource(new McpSchema.UnsubscribeRequest(firstResource.uri()))).verifyComplete();
            }
        }).verifyComplete());
    }

    @Test
    void testNotificationHandlers() {
        AtomicBoolean toolsNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean resourcesNotificationReceived = new AtomicBoolean(false);
        AtomicBoolean promptsNotificationReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.toolsChangeConsumer(tools -> Mono.fromRunnable(() -> toolsNotificationReceived.set(true))).resourcesChangeConsumer(resources -> Mono.fromRunnable(() -> resourcesNotificationReceived.set(true))).promptsChangeConsumer(prompts -> Mono.fromRunnable(() -> promptsNotificationReceived.set(true))), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize()).expectNextMatches(Objects::nonNull).verifyComplete());
    }

    @Test
    void testInitializeWithSamplingCapability() {
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().sampling().build();
        McpSchema.CreateMessageResult createMessageResult = McpSchema.CreateMessageResult.builder().message("test").model("test-model").build();
        this.withClient(this.createMcpTransport(), builder -> builder.capabilities(capabilities).sampling(request -> Mono.just((Object)createMessageResult)), client -> StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete());
    }

    @Test
    void testInitializeWithElicitationCapability() {
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().elicitation().build();
        McpSchema.ElicitResult elicitResult = McpSchema.ElicitResult.builder().message(McpSchema.ElicitResult.Action.ACCEPT).content(Map.of("foo", "bar")).build();
        this.withClient(this.createMcpTransport(), builder -> builder.capabilities(capabilities).elicitation(request -> Mono.just((Object)elicitResult)), client -> StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete());
    }

    @Test
    void testInitializeWithAllCapabilities() {
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().experimental(Map.of("feature", "test")).roots(Boolean.valueOf(true)).sampling().build();
        Function<McpSchema.CreateMessageRequest, Mono> samplingHandler = request -> Mono.just((Object)McpSchema.CreateMessageResult.builder().message("test").model("test-model").build());
        Function<McpSchema.ElicitRequest, Mono> elicitationHandler = request -> Mono.just((Object)McpSchema.ElicitResult.builder().message(McpSchema.ElicitResult.Action.ACCEPT).content(Map.of("foo", "bar")).build());
        this.withClient(this.createMcpTransport(), builder -> builder.capabilities(capabilities).sampling(samplingHandler).elicitation(elicitationHandler), client -> StepVerifier.create((Publisher)client.initialize()).assertNext(result -> {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Object)result.capabilities()).isNotNull();
        }).verifyComplete());
    }

    @Test
    void testLoggingLevelsWithoutInitialization() {
        this.verifyNotificationSucceedsWithImplicitInitialization(client -> client.setLoggingLevel(McpSchema.LoggingLevel.DEBUG), "setting logging level");
    }

    @Test
    void testLoggingLevels() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.initialize().thenMany((Publisher)Flux.fromArray((Object[])McpSchema.LoggingLevel.values()).flatMap(arg_0 -> ((McpAsyncClient)mcpAsyncClient).setLoggingLevel(arg_0)))).verifyComplete());
    }

    @Test
    void testLoggingConsumer() {
        AtomicBoolean logReceived = new AtomicBoolean(false);
        this.withClient(this.createMcpTransport(), builder -> builder.loggingConsumer(notification -> Mono.fromRunnable(() -> logReceived.set(true))), client -> {
            StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete();
            StepVerifier.create((Publisher)client.closeGracefully()).verifyComplete();
        });
    }

    @Test
    void testLoggingWithNullNotification() {
        this.withClient(this.createMcpTransport(), mcpAsyncClient -> StepVerifier.create((Publisher)mcpAsyncClient.setLoggingLevel(null)).expectErrorMatches(error -> error.getMessage().contains("Logging level must not be null")).verify());
    }

    @Test
    void testSampling() {
        McpClientTransport transport = this.createMcpTransport();
        String message = "Hello, world!";
        String response = "Goodbye, world!";
        int maxTokens = 100;
        AtomicReference receivedPrompt = new AtomicReference();
        AtomicReference receivedMessage = new AtomicReference();
        AtomicInteger receivedMaxTokens = new AtomicInteger();
        this.withClient(transport, spec -> spec.capabilities(McpSchema.ClientCapabilities.builder().sampling().build()).sampling(request -> {
            McpSchema.TextContent messageText = (McpSchema.TextContent)org.junit.jupiter.api.Assertions.assertInstanceOf(McpSchema.TextContent.class, (Object)((McpSchema.SamplingMessage)request.messages().get(0)).content());
            receivedPrompt.set(request.systemPrompt());
            receivedMessage.set(messageText.text());
            receivedMaxTokens.set(request.maxTokens());
            return Mono.just((Object)new McpSchema.CreateMessageResult(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Goodbye, world!"), "modelId", McpSchema.CreateMessageResult.StopReason.END_TURN));
        }), client -> {
            StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete();
            StepVerifier.create((Publisher)client.callTool(new McpSchema.CallToolRequest("sampleLLM", Map.of("prompt", "Hello, world!", "maxTokens", 100)))).consumeNextWith(result -> {
                Assertions.assertThat((List)result.content()).hasAtLeastOneElementOfType(McpSchema.TextContent.class);
                Assertions.assertThat((List)result.content()).allSatisfy(content -> {
                    if (!(content instanceof McpSchema.TextContent)) {
                        return;
                    }
                    McpSchema.TextContent text = (McpSchema.TextContent)content;
                    Assertions.assertThat((String)text.text()).endsWith((CharSequence)"Goodbye, world!");
                });
                Assertions.assertThat((String)((String)receivedPrompt.get())).isNotEmpty();
                Assertions.assertThat((String)((String)receivedMessage.get())).endsWith((CharSequence)"Hello, world!");
                Assertions.assertThat((int)receivedMaxTokens.get()).isEqualTo(100);
            }).verifyComplete();
        });
    }

    @Test
    void testProgressConsumer() {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        CopyOnWriteArrayList receivedNotifications = new CopyOnWriteArrayList();
        this.withClient(this.createMcpTransport(), builder -> builder.progressConsumer(notification -> {
            receivedNotifications.add(notification);
            sink.tryEmitNext(notification);
            return Mono.empty();
        }), client -> {
            StepVerifier.create((Publisher)client.initialize()).expectNextMatches(Objects::nonNull).verifyComplete();
            McpSchema.CallToolRequest request = McpSchema.CallToolRequest.builder().name("longRunningOperation").arguments(Map.of("duration", 1, "steps", 2)).progressToken((Object)"test-token").build();
            StepVerifier.create((Publisher)client.callTool(request)).consumeNextWith(result -> Assertions.assertThat((Object)result).isNotNull()).verifyComplete();
            StepVerifier.create((Publisher)sink.asFlux()).expectNextCount(2L).thenCancel().verify(Duration.ofSeconds(3L));
            Assertions.assertThat((List)receivedNotifications).hasSize(2);
            Assertions.assertThat((Object)((McpSchema.ProgressNotification)receivedNotifications.get(0)).progressToken()).isEqualTo((Object)"test-token");
        });
    }
}

