/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.util.ToolsUtils;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractMcpSyncServerTests {
    private static final String TEST_TOOL_NAME = "test-tool";
    private static final String TEST_RESOURCE_URI = "test://resource";
    private static final String TEST_PROMPT_NAME = "test-prompt";

    protected abstract McpServer.SyncSpecification<?> prepareSyncServerBuilder();

    protected void onStart() {
    }

    protected void onClose() {
    }

    @BeforeEach
    void setUp() {
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpServer.sync((McpServerTransportProvider)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport provider must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareSyncServerBuilder().serverInfo(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Server info must not be null");
    }

    @Test
    void testGracefulShutdown() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testImmediateClose() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.close()).doesNotThrowAnyException();
    }

    @Test
    void testGetAsyncServer() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThat((Object)mcpSyncServer.getAsyncServer()).isNotNull();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    @Deprecated
    void testAddTool() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        McpSchema.Tool newTool = McpSchema.Tool.builder().name("new-tool").title("New test tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        Assertions.assertThatCode(() -> mcpSyncServer.addTool(new McpServerFeatures.SyncToolSpecification(newTool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddToolCall() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        McpSchema.Tool newTool = McpSchema.Tool.builder().name("new-tool").title("New test tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        Assertions.assertThatCode(() -> mcpSyncServer.addTool(McpServerFeatures.SyncToolSpecification.builder().tool(newTool).callHandler((exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    @Deprecated
    void testAddDuplicateTool() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name(TEST_TOOL_NAME).title("Duplicate tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tool(duplicateTool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build();
        Assertions.assertThatCode(() -> mcpSyncServer.addTool(new McpServerFeatures.SyncToolSpecification(duplicateTool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddDuplicateToolCall() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name(TEST_TOOL_NAME).title("Duplicate tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(duplicateTool, (exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build();
        Assertions.assertThatCode(() -> mcpSyncServer.addTool(McpServerFeatures.SyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build())).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testDuplicateToolCallDuringBuilding() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name("duplicate-build-toolcall").title("Duplicate toolcall during building").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(duplicateTool, (exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).toolCall(duplicateTool, (exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tool with name 'duplicate-build-toolcall' is already registered.");
    }

    @Test
    void testDuplicateToolsInBatchListRegistration() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name("batch-list-tool").title("Duplicate tool in batch list").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        List<McpServerFeatures.SyncToolSpecification> specs = List.of(McpServerFeatures.SyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build(), McpServerFeatures.SyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(specs).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tool with name 'batch-list-tool' is already registered.");
    }

    @Test
    void testDuplicateToolsInBatchVarargsRegistration() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name("batch-varargs-tool").title("Duplicate tool in batch varargs").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.SyncToolSpecification[]{McpServerFeatures.SyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build(), McpServerFeatures.SyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build()}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tool with name 'batch-varargs-tool' is already registered.");
    }

    @Test
    void testRemoveTool() {
        McpSchema.Tool tool = McpSchema.Tool.builder().name(TEST_TOOL_NAME).title("Test tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(tool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removeTool(TEST_TOOL_NAME)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentTool() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removeTool("nonexistent-tool")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testNotifyToolsListChanged() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyToolsListChanged()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testNotifyResourcesListChanged() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyResourcesListChanged()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testNotifyResourcesUpdated() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyResourcesUpdated(new McpSchema.ResourcesUpdatedNotification(TEST_RESOURCE_URI))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResource() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.SyncResourceSpecification specification = new McpServerFeatures.SyncResourceSpecification(resource, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        Assertions.assertThatCode(() -> mcpSyncServer.addResource(specification)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithNullSpecification() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.addResource((McpServerFeatures.SyncResourceSpecification)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Resource must not be null");
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithoutCapability() {
        McpSyncServer serverWithoutResources = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.SyncResourceSpecification specification = new McpServerFeatures.SyncResourceSpecification(resource, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutResources.addResource(specification)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities");
    }

    @Test
    void testRemoveResourceWithoutCapability() {
        McpSyncServer serverWithoutResources = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutResources.removeResource(TEST_RESOURCE_URI)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities");
    }

    @Test
    void testListResources() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.SyncResourceSpecification specification = new McpServerFeatures.SyncResourceSpecification(resource, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        mcpSyncServer.addResource(specification);
        List resources = mcpSyncServer.listResources();
        Assertions.assertThat((List)resources).hasSize(1);
        Assertions.assertThat((String)((McpSchema.Resource)resources.get(0)).uri()).isEqualTo(TEST_RESOURCE_URI);
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveResource() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.SyncResourceSpecification specification = new McpServerFeatures.SyncResourceSpecification(resource, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        mcpSyncServer.addResource(specification);
        Assertions.assertThatCode(() -> mcpSyncServer.removeResource(TEST_RESOURCE_URI)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentResource() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removeResource("nonexistent://resource")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceTemplate() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.SyncResourceTemplateSpecification specification = new McpServerFeatures.SyncResourceTemplateSpecification(template, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        Assertions.assertThatCode(() -> mcpSyncServer.addResourceTemplate(specification)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceTemplateWithoutCapability() {
        McpSyncServer serverWithoutResources = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.SyncResourceTemplateSpecification specification = new McpServerFeatures.SyncResourceTemplateSpecification(template, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutResources.addResourceTemplate(specification)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities");
    }

    @Test
    void testRemoveResourceTemplate() {
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.SyncResourceTemplateSpecification specification = new McpServerFeatures.SyncResourceTemplateSpecification(template, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).resourceTemplates(new McpServerFeatures.SyncResourceTemplateSpecification[]{specification}).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removeResourceTemplate("test://template/{id}")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveResourceTemplateWithoutCapability() {
        McpSyncServer serverWithoutResources = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutResources.removeResourceTemplate("test://template/{id}")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities");
    }

    @Test
    void testRemoveNonexistentResourceTemplate() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removeResourceTemplate("nonexistent://template/{id}")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testListResourceTemplates() {
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.SyncResourceTemplateSpecification specification = new McpServerFeatures.SyncResourceTemplateSpecification(template, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).resourceTemplates(new McpServerFeatures.SyncResourceTemplateSpecification[]{specification}).build();
        List templates = mcpSyncServer.listResourceTemplates();
        Assertions.assertThat((List)templates).isNotNull();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testNotifyPromptsListChanged() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyPromptsListChanged()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddPromptWithNullSpecification() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(false)).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.addPrompt((McpServerFeatures.SyncPromptSpecification)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Prompt specification must not be null");
    }

    @Test
    void testAddPromptWithoutCapability() {
        McpSyncServer serverWithoutPrompts = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME, "Test Prompt", "Test Prompt", List.of());
        McpServerFeatures.SyncPromptSpecification specification = new McpServerFeatures.SyncPromptSpecification(prompt, (exchange, req) -> new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content")))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutPrompts.addPrompt(specification)).isInstanceOf(IllegalStateException.class)).hasMessage("Server must be configured with prompt capabilities");
    }

    @Test
    void testRemovePromptWithoutCapability() {
        McpSyncServer serverWithoutPrompts = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutPrompts.removePrompt(TEST_PROMPT_NAME)).isInstanceOf(IllegalStateException.class)).hasMessage("Server must be configured with prompt capabilities");
    }

    @Test
    void testRemovePrompt() {
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME, "Test Prompt", "Test Prompt", List.of());
        McpServerFeatures.SyncPromptSpecification specification = new McpServerFeatures.SyncPromptSpecification(prompt, (exchange, req) -> new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content")))));
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).prompts(new McpServerFeatures.SyncPromptSpecification[]{specification}).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removePrompt(TEST_PROMPT_NAME)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentPrompt() {
        McpSyncServer mcpSyncServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removePrompt("nonexistent://template/{id}")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRootsChangeHandlers() {
        McpSchema.Root[] rootsReceived = new McpSchema.Root[1];
        boolean[] consumerCalled = new boolean[1];
        McpSyncServer singleConsumerServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            consumerCalled[0] = true;
            if (!roots.isEmpty()) {
                rootsReceived[0] = (McpSchema.Root)roots.get(0);
            }
        })).build();
        Assertions.assertThat((Object)singleConsumerServer).isNotNull();
        Assertions.assertThatCode(() -> singleConsumerServer.closeGracefully()).doesNotThrowAnyException();
        this.onClose();
        boolean[] consumer1Called = new boolean[1];
        boolean[] consumer2Called = new boolean[1];
        List[] rootsContent = new List[1];
        McpSyncServer multipleConsumersServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            consumer1Called[0] = true;
            rootsContent[0] = roots;
        }, (exchange, roots) -> {
            consumer2Called[0] = true;
        })).build();
        Assertions.assertThat((Object)multipleConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> multipleConsumersServer.closeGracefully()).doesNotThrowAnyException();
        this.onClose();
        McpSyncServer errorHandlingServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            throw new RuntimeException("Test error");
        })).build();
        Assertions.assertThat((Object)errorHandlingServer).isNotNull();
        Assertions.assertThatCode(() -> errorHandlingServer.closeGracefully()).doesNotThrowAnyException();
        this.onClose();
        McpSyncServer noConsumersServer = this.prepareSyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThat((Object)noConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> noConsumersServer.closeGracefully()).doesNotThrowAnyException();
    }
}

