/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.DefaultMcpTransportContext;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

public class WebMvcStatelessServerTransport
implements McpStatelessServerTransport {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcStatelessServerTransport.class);
    private final ObjectMapper objectMapper;
    private final String mcpEndpoint;
    private final RouterFunction<ServerResponse> routerFunction;
    private McpStatelessServerHandler mcpHandler;
    private McpTransportContextExtractor<ServerRequest> contextExtractor;
    private volatile boolean isClosing = false;

    private WebMvcStatelessServerTransport(ObjectMapper objectMapper, String mcpEndpoint, McpTransportContextExtractor<ServerRequest> contextExtractor) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        Assert.notNull((Object)mcpEndpoint, (String)"mcpEndpoint must not be null");
        Assert.notNull(contextExtractor, (String)"contextExtractor must not be null");
        this.objectMapper = objectMapper;
        this.mcpEndpoint = mcpEndpoint;
        this.contextExtractor = contextExtractor;
        this.routerFunction = RouterFunctions.route().GET(this.mcpEndpoint, this::handleGet).POST(this.mcpEndpoint, this::handlePost).build();
    }

    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
    }

    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
        });
    }

    public RouterFunction<ServerResponse> getRouterFunction() {
        return this.routerFunction;
    }

    private ServerResponse handleGet(ServerRequest request) {
        return ServerResponse.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    private ServerResponse handlePost(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)"Server is shutting down");
        }
        McpTransportContext transportContext = this.contextExtractor.extract((Object)request, (McpTransportContext)new DefaultMcpTransportContext());
        List acceptHeaders = request.headers().asHttpHeaders().getAccept();
        if (!acceptHeaders.contains(MediaType.APPLICATION_JSON) || !acceptHeaders.contains(MediaType.TEXT_EVENT_STREAM)) {
            return ServerResponse.badRequest().build();
        }
        try {
            String body = (String)request.body(String.class);
            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)body);
            if (message instanceof McpSchema.JSONRPCRequest) {
                McpSchema.JSONRPCRequest jsonrpcRequest = (McpSchema.JSONRPCRequest)message;
                try {
                    McpSchema.JSONRPCResponse jsonrpcResponse = (McpSchema.JSONRPCResponse)this.mcpHandler.handleRequest(transportContext, jsonrpcRequest).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext)).block();
                    return ServerResponse.ok().contentType(MediaType.APPLICATION_JSON).body((Object)jsonrpcResponse);
                }
                catch (Exception e) {
                    logger.error("Failed to handle request: {}", (Object)e.getMessage());
                    return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new McpError((Object)("Failed to handle request: " + e.getMessage())));
                }
            }
            if (message instanceof McpSchema.JSONRPCNotification) {
                McpSchema.JSONRPCNotification jsonrpcNotification = (McpSchema.JSONRPCNotification)message;
                try {
                    this.mcpHandler.handleNotification(transportContext, jsonrpcNotification).contextWrite(ctx -> ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)transportContext)).block();
                    return ServerResponse.accepted().build();
                }
                catch (Exception e) {
                    logger.error("Failed to handle notification: {}", (Object)e.getMessage());
                    return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new McpError((Object)("Failed to handle notification: " + e.getMessage())));
                }
            }
            return ServerResponse.badRequest().body((Object)new McpError((Object)"The server accepts either requests or notifications"));
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error("Failed to deserialize message: {}", (Object)e.getMessage());
            return ServerResponse.badRequest().body((Object)new McpError((Object)"Invalid message format"));
        }
        catch (Exception e) {
            logger.error("Unexpected error handling message: {}", (Object)e.getMessage());
            return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new McpError((Object)("Unexpected error: " + e.getMessage())));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ObjectMapper objectMapper;
        private String mcpEndpoint = "/mcp";
        private McpTransportContextExtractor<ServerRequest> contextExtractor = (serverRequest, context) -> context;

        private Builder() {
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder messageEndpoint(String messageEndpoint) {
            Assert.notNull((Object)messageEndpoint, (String)"Message endpoint must not be null");
            this.mcpEndpoint = messageEndpoint;
            return this;
        }

        public Builder contextExtractor(McpTransportContextExtractor<ServerRequest> contextExtractor) {
            Assert.notNull(contextExtractor, (String)"Context extractor must not be null");
            this.contextExtractor = contextExtractor;
            return this;
        }

        public WebMvcStatelessServerTransport build() {
            Assert.notNull((Object)this.objectMapper, (String)"ObjectMapper must be set");
            Assert.notNull((Object)this.mcpEndpoint, (String)"Message endpoint must be set");
            return new WebMvcStatelessServerTransport(this.objectMapper, this.mcpEndpoint, this.contextExtractor);
        }
    }
}

