/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.json.jackson3;

import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.TypeRef;
import java.io.IOException;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.json.JsonMapper;

public final class JacksonMcpJsonMapper
implements McpJsonMapper {
    private final JsonMapper jsonMapper;

    public JacksonMcpJsonMapper(JsonMapper jsonMapper) {
        if (jsonMapper == null) {
            throw new IllegalArgumentException("JsonMapper must not be null");
        }
        this.jsonMapper = jsonMapper;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public <T> T readValue(String content, Class<T> type) throws IOException {
        try {
            return (T)this.jsonMapper.readValue(content, type);
        }
        catch (JacksonException ex) {
            throw new IOException("Failed to read value", ex);
        }
    }

    public <T> T readValue(byte[] content, Class<T> type) throws IOException {
        try {
            return (T)this.jsonMapper.readValue(content, type);
        }
        catch (JacksonException ex) {
            throw new IOException("Failed to read value", ex);
        }
    }

    public <T> T readValue(String content, TypeRef<T> type) throws IOException {
        JavaType javaType = this.jsonMapper.getTypeFactory().constructType(type.getType());
        try {
            return (T)this.jsonMapper.readValue(content, javaType);
        }
        catch (JacksonException ex) {
            throw new IOException("Failed to read value", ex);
        }
    }

    public <T> T readValue(byte[] content, TypeRef<T> type) throws IOException {
        JavaType javaType = this.jsonMapper.getTypeFactory().constructType(type.getType());
        try {
            return (T)this.jsonMapper.readValue(content, javaType);
        }
        catch (JacksonException ex) {
            throw new IOException("Failed to read value", ex);
        }
    }

    public <T> T convertValue(Object fromValue, Class<T> type) {
        return (T)this.jsonMapper.convertValue(fromValue, type);
    }

    public <T> T convertValue(Object fromValue, TypeRef<T> type) {
        JavaType javaType = this.jsonMapper.getTypeFactory().constructType(type.getType());
        return (T)this.jsonMapper.convertValue(fromValue, javaType);
    }

    public String writeValueAsString(Object value) throws IOException {
        try {
            return this.jsonMapper.writeValueAsString(value);
        }
        catch (JacksonException ex) {
            throw new IOException("Failed to write value as string", ex);
        }
    }

    public byte[] writeValueAsBytes(Object value) throws IOException {
        try {
            return this.jsonMapper.writeValueAsBytes(value);
        }
        catch (JacksonException ex) {
            throw new IOException("Failed to write value as bytes", ex);
        }
    }
}

