/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.Map;
import java.util.function.Function;

public class McpError
extends RuntimeException {
    public static final Function<String, McpError> RESOURCE_NOT_FOUND = resourceUri -> new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(-32002, "Resource not found", Map.of("uri", resourceUri)));
    private McpSchema.JSONRPCResponse.JSONRPCError jsonRpcError;

    public McpError(McpSchema.JSONRPCResponse.JSONRPCError jsonRpcError) {
        super(jsonRpcError.message());
        this.jsonRpcError = jsonRpcError;
    }

    @Deprecated
    public McpError(Object error) {
        super(error.toString());
    }

    public McpSchema.JSONRPCResponse.JSONRPCError getJsonRpcError() {
        return this.jsonRpcError;
    }

    public static Builder builder(int errorCode) {
        return new Builder(errorCode);
    }

    public static class Builder {
        private final int code;
        private String message;
        private Object data;

        private Builder(int code) {
            this.code = code;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public McpError build() {
            Assert.hasText(this.message, "message must not be empty");
            return new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(this.code, this.message, this.data));
        }
    }
}

