/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.TypeRef;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpNotificationHandler;
import io.modelcontextprotocol.server.McpRequestHandler;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.DefaultMcpStreamableServerSessionFactory;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProviderBase;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncServer.class);
    private final McpServerTransportProviderBase mcpTransportProvider;
    private final McpJsonMapper jsonMapper;
    private final JsonSchemaValidator jsonSchemaValidator;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final String instructions;
    private final CopyOnWriteArrayList<McpServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<McpSchema.ResourceTemplate> resourceTemplates = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
    private McpSchema.LoggingLevel minLoggingLevel = McpSchema.LoggingLevel.DEBUG;
    private final ConcurrentHashMap<McpSchema.CompleteReference, McpServerFeatures.AsyncCompletionSpecification> completions = new ConcurrentHashMap();
    private List<String> protocolVersions;
    private McpUriTemplateManagerFactory uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();

    McpAsyncServer(McpServerTransportProvider mcpTransportProvider, McpJsonMapper jsonMapper, McpServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransportProvider;
        this.jsonMapper = jsonMapper;
        this.serverInfo = features.serverInfo();
        this.serverCapabilities = features.serverCapabilities().mutate().logging().build();
        this.instructions = features.instructions();
        this.tools.addAll(McpAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.tools()));
        this.resources.putAll(features.resources());
        this.resourceTemplates.addAll(features.resourceTemplates());
        this.prompts.putAll(features.prompts());
        this.completions.putAll(features.completions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        Map<String, McpRequestHandler<?>> requestHandlers = this.prepareRequestHandlers();
        Map<String, McpNotificationHandler> notificationHandlers = this.prepareNotificationHandlers(features);
        this.protocolVersions = mcpTransportProvider.protocolVersions();
        mcpTransportProvider.setSessionFactory(transport -> new McpServerSession(UUID.randomUUID().toString(), requestTimeout, transport, this::asyncInitializeRequestHandler, requestHandlers, notificationHandlers));
    }

    McpAsyncServer(McpStreamableServerTransportProvider mcpTransportProvider, McpJsonMapper jsonMapper, McpServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransportProvider;
        this.jsonMapper = jsonMapper;
        this.serverInfo = features.serverInfo();
        this.serverCapabilities = features.serverCapabilities().mutate().logging().build();
        this.instructions = features.instructions();
        this.tools.addAll(McpAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.tools()));
        this.resources.putAll(features.resources());
        this.resourceTemplates.addAll(features.resourceTemplates());
        this.prompts.putAll(features.prompts());
        this.completions.putAll(features.completions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        Map<String, McpRequestHandler<?>> requestHandlers = this.prepareRequestHandlers();
        Map<String, McpNotificationHandler> notificationHandlers = this.prepareNotificationHandlers(features);
        this.protocolVersions = mcpTransportProvider.protocolVersions();
        mcpTransportProvider.setSessionFactory(new DefaultMcpStreamableServerSessionFactory(requestTimeout, this::asyncInitializeRequestHandler, requestHandlers, notificationHandlers));
    }

    private Map<String, McpNotificationHandler> prepareNotificationHandlers(McpServerFeatures.Async features) {
        HashMap<String, McpNotificationHandler> notificationHandlers = new HashMap<String, McpNotificationHandler>();
        notificationHandlers.put("notifications/initialized", (exchange, params) -> Mono.empty());
        List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers = features.rootsChangeConsumers();
        if (Utils.isEmpty(rootsChangeConsumers)) {
            rootsChangeConsumers = List.of((exchange, roots) -> Mono.fromRunnable(() -> logger.warn("Roots list changed notification, but no consumers provided. Roots list changed: {}", roots)));
        }
        notificationHandlers.put("notifications/roots/list_changed", this.asyncRootsListChangedNotificationHandler(rootsChangeConsumers));
        return notificationHandlers;
    }

    private Map<String, McpRequestHandler<?>> prepareRequestHandlers() {
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", (exchange, params) -> Mono.just(Map.of()));
        if (this.serverCapabilities.tools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (this.serverCapabilities.resources() != null) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (this.serverCapabilities.prompts() != null) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        if (this.serverCapabilities.logging() != null) {
            requestHandlers.put("logging/setLevel", this.setLoggerRequestHandler());
        }
        if (this.serverCapabilities.completions() != null) {
            requestHandlers.put("completion/complete", this.completionCompleteRequestHandler());
        }
        return requestHandlers;
    }

    private Mono<McpSchema.InitializeResult> asyncInitializeRequestHandler(McpSchema.InitializeRequest initializeRequest) {
        return Mono.defer(() -> {
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.protocolVersion(), initializeRequest.capabilities(), initializeRequest.clientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.protocolVersion())) {
                serverProtocolVersion = initializeRequest.protocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will suggest the {} version instead", (Object)initializeRequest.protocolVersion(), (Object)serverProtocolVersion);
            }
            return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, this.instructions));
        });
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public Mono<Void> closeGracefully() {
        return this.mcpTransportProvider.closeGracefully();
    }

    public void close() {
        this.mcpTransportProvider.close();
    }

    private McpNotificationHandler asyncRootsListChangedNotificationHandler(List<BiFunction<McpAsyncServerExchange, List<McpSchema.Root>, Mono<Void>>> rootsChangeConsumers) {
        return (exchange, params) -> exchange.listRoots().flatMap(listRootsResult -> Flux.fromIterable((Iterable)rootsChangeConsumers).flatMap(consumer -> Mono.defer(() -> (Mono)consumer.apply(exchange, listRootsResult.roots()))).onErrorResume(error -> {
            logger.error("Error handling roots list change notification", error);
            return Mono.empty();
        }).then());
    }

    public Mono<Void> addTool(McpServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool specification must not be null"));
        }
        if (toolSpecification.tool() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool must not be null"));
        }
        if (toolSpecification.call() == null && toolSpecification.callHandler() == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool call handler must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        McpServerFeatures.AsyncToolSpecification wrappedToolSpecification = McpAsyncServer.withStructuredOutputHandling(this.jsonSchemaValidator, toolSpecification);
        return Mono.defer(() -> {
            if (this.tools.stream().anyMatch(th -> th.tool().name().equals(wrappedToolSpecification.tool().name()))) {
                return Mono.error((Throwable)new McpError((Object)("Tool with name '" + wrappedToolSpecification.tool().name() + "' already exists")));
            }
            this.tools.add(wrappedToolSpecification);
            logger.debug("Added tool handler: {}", (Object)wrappedToolSpecification.tool().name());
            if (this.serverCapabilities.tools().listChanged().booleanValue()) {
                return this.notifyToolsListChanged();
            }
            return Mono.empty();
        });
    }

    private static List<McpServerFeatures.AsyncToolSpecification> withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, List<McpServerFeatures.AsyncToolSpecification> tools) {
        if (Utils.isEmpty(tools)) {
            return tools;
        }
        return tools.stream().map(tool -> McpAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, tool)).toList();
    }

    private static McpServerFeatures.AsyncToolSpecification withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, McpServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification.callHandler() instanceof StructuredOutputCallToolHandler) {
            return toolSpecification;
        }
        if (toolSpecification.tool().outputSchema() == null) {
            return toolSpecification;
        }
        return McpServerFeatures.AsyncToolSpecification.builder().tool(toolSpecification.tool()).callHandler(new StructuredOutputCallToolHandler(jsonSchemaValidator, toolSpecification.tool().outputSchema(), toolSpecification.callHandler())).build();
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new McpError((Object)"Tool name must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            boolean removed = this.tools.removeIf(toolSpecification -> toolSpecification.tool().name().equals(toolName));
            if (removed) {
                logger.debug("Removed tool handler: {}", (Object)toolName);
                if (this.serverCapabilities.tools().listChanged().booleanValue()) {
                    return this.notifyToolsListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Tool with name '" + toolName + "' not found")));
        });
    }

    public Mono<Void> notifyToolsListChanged() {
        return this.mcpTransportProvider.notifyClients("notifications/tools/list_changed", null);
    }

    private McpRequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.Tool> tools = this.tools.stream().map(McpServerFeatures.AsyncToolSpecification::tool).toList();
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private McpRequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return (exchange, params) -> {
            McpSchema.CallToolRequest callToolRequest = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.CallToolRequest>(){});
            Optional<McpServerFeatures.AsyncToolSpecification> toolSpecification = this.tools.stream().filter(tr -> callToolRequest.name().equals(tr.tool().name())).findAny();
            if (toolSpecification.isEmpty()) {
                return Mono.error((Throwable)new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(-32602, "Unknown tool: invalid_tool_name", "Tool not found: " + callToolRequest.name())));
            }
            return toolSpecification.get().callHandler().apply(exchange, callToolRequest);
        };
    }

    public Mono<Void> addResource(McpServerFeatures.AsyncResourceSpecification resourceSpecification) {
        if (resourceSpecification == null || resourceSpecification.resource() == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            if (this.resources.putIfAbsent(resourceSpecification.resource().uri(), resourceSpecification) != null) {
                return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceSpecification.resource().uri() + "' already exists")));
            }
            logger.debug("Added resource handler: {}", (Object)resourceSpecification.resource().uri());
            if (this.serverCapabilities.resources().listChanged().booleanValue()) {
                return this.notifyResourcesListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new McpError((Object)"Resource URI must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
            if (removed != null) {
                logger.debug("Removed resource handler: {}", (Object)resourceUri);
                if (this.serverCapabilities.resources().listChanged().booleanValue()) {
                    return this.notifyResourcesListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Resource with URI '" + resourceUri + "' not found")));
        });
    }

    public Mono<Void> notifyResourcesListChanged() {
        return this.mcpTransportProvider.notifyClients("notifications/resources/list_changed", null);
    }

    public Mono<Void> notifyResourcesUpdated(McpSchema.ResourcesUpdatedNotification resourcesUpdatedNotification) {
        return this.mcpTransportProvider.notifyClients("notifications/resources/updated", resourcesUpdatedNotification);
    }

    private McpRequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpServerFeatures.AsyncResourceSpecification::resource).filter(resource -> !resource.uri().contains("{")).toList();
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private McpRequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return (exchange, params) -> Mono.just((Object)new McpSchema.ListResourceTemplatesResult(this.getResourceTemplates(), null));
    }

    private List<McpSchema.ResourceTemplate> getResourceTemplates() {
        ArrayList<McpSchema.ResourceTemplate> list = new ArrayList<McpSchema.ResourceTemplate>(this.resourceTemplates);
        List<McpSchema.ResourceTemplate> resourceTemplates = this.resources.keySet().stream().filter(uri -> uri.contains("{")).map(uri -> {
            McpSchema.Resource resource = this.resources.get(uri).resource();
            McpSchema.ResourceTemplate template = new McpSchema.ResourceTemplate(resource.uri(), resource.name(), resource.title(), resource.description(), resource.mimeType(), resource.annotations());
            return template;
        }).toList();
        list.addAll(resourceTemplates);
        return list;
    }

    private McpRequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return (ex, params) -> {
            McpSchema.ReadResourceRequest resourceRequest = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.uri();
            return this.asyncResourceSpecification(resourceUri).map(spec -> Mono.defer(() -> spec.readHandler().apply(ex, resourceRequest))).orElseGet(() -> Mono.error((Throwable)McpError.RESOURCE_NOT_FOUND.apply(resourceUri)));
        };
    }

    private Optional<McpServerFeatures.AsyncResourceSpecification> asyncResourceSpecification(String uri) {
        return this.resources.values().stream().filter(spec -> this.uriTemplateManagerFactory.create(spec.resource().uri()).matches(uri)).findFirst();
    }

    public Mono<Void> addPrompt(McpServerFeatures.AsyncPromptSpecification promptSpecification) {
        if (promptSpecification == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt specification must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncPromptSpecification specification = this.prompts.putIfAbsent(promptSpecification.prompt().name(), promptSpecification);
            if (specification != null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptSpecification.prompt().name() + "' already exists")));
            }
            logger.debug("Added prompt handler: {}", (Object)promptSpecification.prompt().name());
            if (this.serverCapabilities.prompts().listChanged().booleanValue()) {
                return this.notifyPromptsListChanged();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new McpError((Object)"Prompt name must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new McpError((Object)"Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
            if (removed != null) {
                logger.debug("Removed prompt handler: {}", (Object)promptName);
                if (this.serverCapabilities.prompts().listChanged().booleanValue()) {
                    return this.notifyPromptsListChanged();
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new McpError((Object)("Prompt with name '" + promptName + "' not found")));
        });
    }

    public Mono<Void> notifyPromptsListChanged() {
        return this.mcpTransportProvider.notifyClients("notifications/prompts/list_changed", null);
    }

    private McpRequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpServerFeatures.AsyncPromptSpecification::prompt).toList();
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private McpRequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return (exchange, params) -> {
            McpSchema.GetPromptRequest promptRequest = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.GetPromptRequest>(){});
            McpServerFeatures.AsyncPromptSpecification specification = this.prompts.get(promptRequest.name());
            if (specification == null) {
                return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptRequest.name())));
            }
            return Mono.defer(() -> specification.promptHandler().apply(exchange, promptRequest));
        };
    }

    @Deprecated
    public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        if (loggingMessageNotification == null) {
            return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
        }
        if (loggingMessageNotification.level().level() < this.minLoggingLevel.level()) {
            return Mono.empty();
        }
        return this.mcpTransportProvider.notifyClients("notifications/message", loggingMessageNotification);
    }

    private McpRequestHandler<Object> setLoggerRequestHandler() {
        return (exchange, params) -> Mono.defer(() -> {
            McpSchema.SetLevelRequest newMinLoggingLevel = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.SetLevelRequest>(){});
            exchange.setMinLoggingLevel(newMinLoggingLevel.level());
            this.minLoggingLevel = newMinLoggingLevel.level();
            return Mono.just(Map.of());
        });
    }

    private McpRequestHandler<McpSchema.CompleteResult> completionCompleteRequestHandler() {
        return (exchange, params) -> {
            McpServerFeatures.AsyncCompletionSpecification specification;
            McpSchema.CompleteReference patt33263$temp;
            McpSchema.CompleteReference patt32688$temp;
            McpSchema.CompleteRequest request = this.parseCompletionParams(params);
            if (request.ref() == null) {
                return Mono.error((Throwable)new McpError((Object)"ref must not be null"));
            }
            if (request.ref().type() == null) {
                return Mono.error((Throwable)new McpError((Object)"type must not be null"));
            }
            String type = request.ref().type();
            String argumentName = request.argument().name();
            if (type.equals("ref/prompt") && (patt32688$temp = request.ref()) instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptReference = (McpSchema.PromptReference)patt32688$temp;
                McpServerFeatures.AsyncPromptSpecification promptSpec = this.prompts.get(promptReference.name());
                if (promptSpec == null) {
                    return Mono.error((Throwable)new McpError((Object)("Prompt not found: " + promptReference.name())));
                }
                if (!promptSpec.prompt().arguments().stream().filter(arg -> arg.name().equals(argumentName)).findFirst().isPresent()) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if (type.equals("ref/resource") && (patt33263$temp = request.ref()) instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceReference = (McpSchema.ResourceReference)patt33263$temp;
                McpServerFeatures.AsyncResourceSpecification resourceSpec = this.resources.get(resourceReference.uri());
                if (resourceSpec == null) {
                    return Mono.error((Throwable)McpError.RESOURCE_NOT_FOUND.apply(resourceReference.uri()));
                }
                if (!this.uriTemplateManagerFactory.create(resourceSpec.resource().uri()).getVariableNames().contains(argumentName)) {
                    return Mono.error((Throwable)new McpError((Object)("Argument not found: " + argumentName)));
                }
            }
            if ((specification = this.completions.get(request.ref())) == null) {
                return Mono.error((Throwable)new McpError((Object)("AsyncCompletionSpecification not found: " + String.valueOf(request.ref()))));
            }
            return Mono.defer(() -> specification.completionHandler().apply(exchange, request));
        };
    }

    private McpSchema.CompleteRequest parseCompletionParams(Object object) {
        String refType;
        Map params = (Map)object;
        Map refMap = (Map)params.get("ref");
        Map argMap = (Map)params.get("argument");
        Map contextMap = (Map)params.get("context");
        Map meta = (Map)params.get("_meta");
        Record ref = switch (refType = (String)refMap.get("type")) {
            case "ref/prompt" -> new McpSchema.PromptReference(refType, (String)refMap.get("name"), refMap.get("title") != null ? (String)refMap.get("title") : null);
            case "ref/resource" -> new McpSchema.ResourceReference(refType, (String)refMap.get("uri"));
            default -> throw new IllegalArgumentException("Invalid ref type: " + refType);
        };
        String argName = (String)argMap.get("name");
        String argValue = (String)argMap.get("value");
        McpSchema.CompleteRequest.CompleteArgument argument = new McpSchema.CompleteRequest.CompleteArgument(argName, argValue);
        McpSchema.CompleteRequest.CompleteContext context = null;
        if (contextMap != null) {
            Map arguments = (Map)contextMap.get("arguments");
            context = new McpSchema.CompleteRequest.CompleteContext(arguments);
        }
        return new McpSchema.CompleteRequest((McpSchema.CompleteReference)((Object)ref), argument, meta, context);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    private static class StructuredOutputCallToolHandler
    implements BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> {
        private final BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateCallToolResult;
        private final JsonSchemaValidator jsonSchemaValidator;
        private final Map<String, Object> outputSchema;

        public StructuredOutputCallToolHandler(JsonSchemaValidator jsonSchemaValidator, Map<String, Object> outputSchema, BiFunction<McpAsyncServerExchange, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            Assert.notNull(delegateHandler, "Delegate call tool result handler must not be null");
            this.delegateCallToolResult = delegateHandler;
            this.outputSchema = outputSchema;
            this.jsonSchemaValidator = jsonSchemaValidator;
        }

        @Override
        public Mono<McpSchema.CallToolResult> apply(McpAsyncServerExchange exchange, McpSchema.CallToolRequest request) {
            return this.delegateCallToolResult.apply(exchange, request).map(result -> {
                if (Boolean.TRUE.equals(result.isError())) {
                    return result;
                }
                if (this.outputSchema == null) {
                    if (result.structuredContent() != null) {
                        logger.warn("Tool call with no outputSchema is not expected to have a result with structured content, but got: {}", result.structuredContent());
                    }
                    return result;
                }
                if (result.structuredContent() == null) {
                    logger.warn("Response missing structured content which is expected when calling tool with non-empty outputSchema");
                    return new McpSchema.CallToolResult("Response missing structured content which is expected when calling tool with non-empty outputSchema", (Boolean)true);
                }
                JsonSchemaValidator.ValidationResponse validation = this.jsonSchemaValidator.validate(this.outputSchema, result.structuredContent());
                if (!validation.valid()) {
                    logger.warn("Tool call result validation failed: {}", (Object)validation.errorMessage());
                    return new McpSchema.CallToolResult(validation.errorMessage(), (Boolean)true);
                }
                if (Utils.isEmpty(result.content())) {
                    return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(validation.jsonStructuredOutput()))).isError(result.isError()).structuredContent(result.structuredContent()).build();
                }
                return result;
            });
        }
    }
}

