/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.common.transformation;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001&B/\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\r\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J5\u0010\u001f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\u0011\u0010#\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0000H\u0086\u0004J\b\u0010$\u001a\u00020%H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u0006'"}, d2={"Lio/mockk/proxy/common/transformation/ClassTransformationSpec;", "", "cls", "Ljava/lang/Class;", "simpleIntercept", "", "staticIntercept", "constructorIntercept", "(Ljava/lang/Class;III)V", "getCls", "()Ljava/lang/Class;", "getConstructorIntercept", "()I", "shouldDoConstructorIntercept", "", "getShouldDoConstructorIntercept", "()Z", "shouldDoSimpleIntercept", "getShouldDoSimpleIntercept", "shouldDoSomething", "getShouldDoSomething", "shouldDoStaticIntercept", "getShouldDoStaticIntercept", "getSimpleIntercept", "getStaticIntercept", "categories", "Lio/mockk/proxy/common/transformation/ClassTransformationSpec$Categories;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "sameTransforms", "toString", "", "Categories", "mockk-agent-api"})
public final class ClassTransformationSpec {
    @NotNull
    private final Class<?> cls;
    private final int simpleIntercept;
    private final int staticIntercept;
    private final int constructorIntercept;

    public ClassTransformationSpec(@NotNull Class<?> cls, int simpleIntercept, int staticIntercept, int constructorIntercept) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        this.cls = cls;
        this.simpleIntercept = simpleIntercept;
        this.staticIntercept = staticIntercept;
        this.constructorIntercept = constructorIntercept;
    }

    public /* synthetic */ ClassTransformationSpec(Class clazz, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        this(clazz, n, n2, n3);
    }

    @NotNull
    public final Class<?> getCls() {
        return this.cls;
    }

    public final int getSimpleIntercept() {
        return this.simpleIntercept;
    }

    public final int getStaticIntercept() {
        return this.staticIntercept;
    }

    public final int getConstructorIntercept() {
        return this.constructorIntercept;
    }

    public final boolean getShouldDoSimpleIntercept() {
        return this.simpleIntercept > 0;
    }

    public final boolean getShouldDoStaticIntercept() {
        return this.staticIntercept > 0;
    }

    public final boolean getShouldDoConstructorIntercept() {
        return this.constructorIntercept > 0;
    }

    public final boolean getShouldDoSomething() {
        return this.getShouldDoSimpleIntercept() || this.getShouldDoStaticIntercept() || this.getShouldDoConstructorIntercept();
    }

    private final Categories categories() {
        return new Categories(this.getShouldDoSimpleIntercept(), this.getShouldDoStaticIntercept(), this.getShouldDoConstructorIntercept());
    }

    public final boolean sameTransforms(@NotNull ClassTransformationSpec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.categories(), (Object)other.categories());
    }

    @NotNull
    public String toString() {
        List lst = new ArrayList();
        if (this.getShouldDoSimpleIntercept()) {
            lst.add("mockk");
        }
        if (this.getShouldDoStaticIntercept()) {
            lst.add("mockkStatic");
        }
        if (this.getShouldDoConstructorIntercept()) {
            lst.add("mockkConstructor");
        }
        return CollectionsKt.joinToString$default((Iterable)lst, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final Class<?> component1() {
        return this.cls;
    }

    public final int component2() {
        return this.simpleIntercept;
    }

    public final int component3() {
        return this.staticIntercept;
    }

    public final int component4() {
        return this.constructorIntercept;
    }

    @NotNull
    public final ClassTransformationSpec copy(@NotNull Class<?> cls, int simpleIntercept, int staticIntercept, int constructorIntercept) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        return new ClassTransformationSpec(cls, simpleIntercept, staticIntercept, constructorIntercept);
    }

    public static /* synthetic */ ClassTransformationSpec copy$default(ClassTransformationSpec classTransformationSpec, Class clazz, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            clazz = classTransformationSpec.cls;
        }
        if ((n4 & 2) != 0) {
            n = classTransformationSpec.simpleIntercept;
        }
        if ((n4 & 4) != 0) {
            n2 = classTransformationSpec.staticIntercept;
        }
        if ((n4 & 8) != 0) {
            n3 = classTransformationSpec.constructorIntercept;
        }
        return classTransformationSpec.copy(clazz, n, n2, n3);
    }

    public int hashCode() {
        int result = this.cls.hashCode();
        result = result * 31 + Integer.hashCode(this.simpleIntercept);
        result = result * 31 + Integer.hashCode(this.staticIntercept);
        result = result * 31 + Integer.hashCode(this.constructorIntercept);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassTransformationSpec)) {
            return false;
        }
        ClassTransformationSpec classTransformationSpec = (ClassTransformationSpec)other;
        if (!Intrinsics.areEqual(this.cls, classTransformationSpec.cls)) {
            return false;
        }
        if (this.simpleIntercept != classTransformationSpec.simpleIntercept) {
            return false;
        }
        if (this.staticIntercept != classTransformationSpec.staticIntercept) {
            return false;
        }
        return this.constructorIntercept == classTransformationSpec.constructorIntercept;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/mockk/proxy/common/transformation/ClassTransformationSpec$Categories;", "", "simple", "", "static", "constructor", "(ZZZ)V", "getConstructor", "()Z", "getSimple", "getStatic", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "mockk-agent-api"})
    private static final class Categories {
        private final boolean simple;
        private final boolean static;
        private final boolean constructor;

        public Categories(boolean simple, boolean bl, boolean constructor) {
            this.simple = simple;
            this.static = bl;
            this.constructor = constructor;
        }

        public final boolean getSimple() {
            return this.simple;
        }

        public final boolean getStatic() {
            return this.static;
        }

        public final boolean getConstructor() {
            return this.constructor;
        }

        public final boolean component1() {
            return this.simple;
        }

        public final boolean component2() {
            return this.static;
        }

        public final boolean component3() {
            return this.constructor;
        }

        @NotNull
        public final Categories copy(boolean simple, boolean bl, boolean constructor) {
            return new Categories(simple, bl, constructor);
        }

        public static /* synthetic */ Categories copy$default(Categories categories, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = categories.simple;
            }
            if ((n & 2) != 0) {
                bl2 = categories.static;
            }
            if ((n & 4) != 0) {
                bl3 = categories.constructor;
            }
            return categories.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "Categories(simple=" + this.simple + ", static=" + this.static + ", constructor=" + this.constructor + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.simple);
            result = result * 31 + Boolean.hashCode(this.static);
            result = result * 31 + Boolean.hashCode(this.constructor);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Categories)) {
                return false;
            }
            Categories categories = (Categories)other;
            if (this.simple != categories.simple) {
                return false;
            }
            if (this.static != categories.static) {
                return false;
            }
            return this.constructor == categories.constructor;
        }
    }
}

