/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response.basic;

import com.alibaba.fastjson.JSONObject;
import io.milvus.exception.ParamException;
import io.milvus.grpc.FieldData;
import io.milvus.response.FieldDataWrapper;
import io.milvus.response.QueryResultsWrapper;
import java.util.List;

public abstract class RowRecordWrapper {
    public abstract List<QueryResultsWrapper.RowRecord> getRowRecords();

    public FieldDataWrapper getDynamicWrapper() throws ParamException {
        List<FieldData> fields = this.getFieldDataList();
        for (FieldData field : fields) {
            if (!field.getIsDynamic()) continue;
            return new FieldDataWrapper(field);
        }
        throw new ParamException("The dynamic field doesn't exist");
    }

    protected QueryResultsWrapper.RowRecord buildRowRecord(QueryResultsWrapper.RowRecord record, long index) {
        for (String outputKey : this.getOutputFields()) {
            FieldDataWrapper dynamicField;
            Object obj;
            boolean isField = false;
            for (FieldData field : this.getFieldDataList()) {
                if (!outputKey.equals(field.getFieldName())) continue;
                FieldDataWrapper wrapper = new FieldDataWrapper(field);
                if (index < 0L || index >= wrapper.getRowCount()) {
                    throw new ParamException("Index out of range");
                }
                Object value = wrapper.valueByIdx((int)index);
                if (wrapper.isJsonField()) {
                    JSONObject jsonField = JSONObject.parseObject((String)new String((byte[])value));
                    if (wrapper.isDynamicField()) {
                        for (String key : jsonField.keySet()) {
                            record.put(key, jsonField.get((Object)key));
                        }
                    } else {
                        record.put(field.getFieldName(), jsonField);
                    }
                } else {
                    record.put(field.getFieldName(), value);
                }
                isField = true;
                break;
            }
            if (isField || (obj = (dynamicField = this.getDynamicWrapper()).get((int)index, outputKey)) == null) continue;
            record.put(outputKey, obj);
        }
        return record;
    }

    protected abstract List<FieldData> getFieldDataList();

    protected abstract List<String> getOutputFields();
}

