/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ConnectParam {
    private final String host;
    private final int port;
    private final String uri;
    private final long connectTimeoutMs;
    private final long keepAliveTimeMs;
    private final long keepAliveTimeoutMs;
    private final boolean keepAliveWithoutCalls;
    private final boolean secure;
    private final long idleTimeoutMs;
    private final String authorization;

    private ConnectParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.host = builder.host;
        this.port = builder.port;
        this.uri = builder.uri;
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.keepAliveTimeMs = builder.keepAliveTimeMs;
        this.keepAliveTimeoutMs = builder.keepAliveTimeoutMs;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.idleTimeoutMs = builder.idleTimeoutMs;
        this.secure = builder.secure;
        this.authorization = builder.authorization;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public long getKeepAliveTimeMs() {
        return this.keepAliveTimeMs;
    }

    public long getKeepAliveTimeoutMs() {
        return this.keepAliveTimeoutMs;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "ConnectParam{host='" + this.host + '\'' + ", port='" + this.port + '}';
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 19530;
        private String uri;
        private long connectTimeoutMs = 10000L;
        private long keepAliveTimeMs = Long.MAX_VALUE;
        private long keepAliveTimeoutMs = 20000L;
        private boolean keepAliveWithoutCalls = false;
        private boolean secure = false;
        private long idleTimeoutMs = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
        private String authorization = Base64.getEncoder().encodeToString("root:milvus".getBytes(StandardCharsets.UTF_8));

        private Builder() {
        }

        public Builder withHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder withConnectTimeout(long connectTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.connectTimeoutMs = timeUnit.toMillis(connectTimeout);
            return this;
        }

        public Builder withKeepAliveTime(long keepAliveTime, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.keepAliveTimeMs = timeUnit.toMillis(keepAliveTime);
            return this;
        }

        public Builder withKeepAliveTimeout(long keepAliveTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.keepAliveTimeoutMs = timeUnit.toMillis(keepAliveTimeout);
            return this;
        }

        public Builder keepAliveWithoutCalls(boolean enable) {
            this.keepAliveWithoutCalls = enable;
            return this;
        }

        public Builder secure(boolean enable) {
            this.secure = enable;
            return this;
        }

        public Builder withIdleTimeout(long idleTimeout, @NonNull TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new NullPointerException("timeUnit is marked non-null but is null");
            }
            this.idleTimeoutMs = timeUnit.toMillis(idleTimeout);
            return this;
        }

        public Builder withAuthorization(@NonNull String username, @NonNull String password) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.authorization = Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder withAuthorization(@NonNull String authorization) {
            if (authorization == null) {
                throw new NullPointerException("authorization is marked non-null but is null");
            }
            this.authorization = authorization;
            return this;
        }

        public ConnectParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.host, "Host name");
            if (StringUtils.isNotEmpty((CharSequence)this.uri)) {
                if (this.uri.startsWith("https://")) {
                    this.uri = this.uri.replace("https://", "");
                    this.secure = true;
                } else if (this.uri.startsWith("http://")) {
                    this.uri = this.uri.replace("http://", "");
                }
                String[] uriArray = this.uri.split(":");
                this.host = uriArray[0];
                if (uriArray.length == 2) {
                    this.port = Integer.valueOf(uriArray[1]);
                }
            }
            if (this.port < 0 || this.port > 65535) {
                throw new ParamException("Port is out of range!");
            }
            if (this.keepAliveTimeMs <= 0L) {
                throw new ParamException("Keep alive time must be positive!");
            }
            if (this.connectTimeoutMs <= 0L) {
                throw new ParamException("Connect timeout must be positive!");
            }
            if (this.keepAliveTimeoutMs <= 0L) {
                throw new ParamException("Keep alive timeout must be positive!");
            }
            if (this.idleTimeoutMs <= 0L) {
                throw new ParamException("Idle timeout must be positive!");
            }
            return new ConnectParam(this);
        }
    }
}

