/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.StatusRuntimeException;
import io.milvus.client.MilvusClient;
import io.milvus.exception.ClientNotConnectedException;
import io.milvus.exception.IllegalResponseException;
import io.milvus.exception.ParamException;
import io.milvus.grpc.AlterAliasRequest;
import io.milvus.grpc.BoolResponse;
import io.milvus.grpc.CheckHealthRequest;
import io.milvus.grpc.CheckHealthResponse;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.CreateAliasRequest;
import io.milvus.grpc.CreateCollectionRequest;
import io.milvus.grpc.CreateCredentialRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.CreatePartitionRequest;
import io.milvus.grpc.CreateRoleRequest;
import io.milvus.grpc.DeleteCredentialRequest;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DropAliasRequest;
import io.milvus.grpc.DropCollectionRequest;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.DropPartitionRequest;
import io.milvus.grpc.DropRoleRequest;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FlushRequest;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCollectionStatisticsRequest;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetCompactionPlansRequest;
import io.milvus.grpc.GetCompactionPlansResponse;
import io.milvus.grpc.GetCompactionStateRequest;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushStateRequest;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetImportStateRequest;
import io.milvus.grpc.GetImportStateResponse;
import io.milvus.grpc.GetIndexBuildProgressRequest;
import io.milvus.grpc.GetIndexBuildProgressResponse;
import io.milvus.grpc.GetIndexStateRequest;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.GetLoadingProgressRequest;
import io.milvus.grpc.GetLoadingProgressResponse;
import io.milvus.grpc.GetMetricsRequest;
import io.milvus.grpc.GetMetricsResponse;
import io.milvus.grpc.GetPartitionStatisticsRequest;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.GetPersistentSegmentInfoRequest;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoRequest;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.GetReplicasRequest;
import io.milvus.grpc.GetReplicasResponse;
import io.milvus.grpc.GetVersionRequest;
import io.milvus.grpc.GetVersionResponse;
import io.milvus.grpc.GrantEntity;
import io.milvus.grpc.GrantorEntity;
import io.milvus.grpc.HasCollectionRequest;
import io.milvus.grpc.HasPartitionRequest;
import io.milvus.grpc.ImportRequest;
import io.milvus.grpc.ImportResponse;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.IndexState;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.ListCredUsersRequest;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.ListImportTasksRequest;
import io.milvus.grpc.ListImportTasksResponse;
import io.milvus.grpc.LoadBalanceRequest;
import io.milvus.grpc.LoadCollectionRequest;
import io.milvus.grpc.LoadPartitionsRequest;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.ManualCompactionRequest;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.ObjectEntity;
import io.milvus.grpc.OperatePrivilegeRequest;
import io.milvus.grpc.OperatePrivilegeType;
import io.milvus.grpc.OperateUserRoleRequest;
import io.milvus.grpc.OperateUserRoleType;
import io.milvus.grpc.PrivilegeEntity;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.ReleaseCollectionRequest;
import io.milvus.grpc.ReleasePartitionsRequest;
import io.milvus.grpc.RoleEntity;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.SelectGrantRequest;
import io.milvus.grpc.SelectGrantResponse;
import io.milvus.grpc.SelectRoleRequest;
import io.milvus.grpc.SelectRoleResponse;
import io.milvus.grpc.SelectUserRequest;
import io.milvus.grpc.SelectUserResponse;
import io.milvus.grpc.ShowCollectionsRequest;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsRequest;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.grpc.ShowType;
import io.milvus.grpc.Status;
import io.milvus.grpc.UpdateCredentialRequest;
import io.milvus.grpc.UserEntity;
import io.milvus.param.ParamUtils;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.alias.AlterAliasParam;
import io.milvus.param.alias.CreateAliasParam;
import io.milvus.param.alias.DropAliasParam;
import io.milvus.param.bulkinsert.BulkInsertParam;
import io.milvus.param.bulkinsert.GetBulkInsertStateParam;
import io.milvus.param.bulkinsert.ListBulkInsertTasksParam;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.GetCollectionStatisticsParam;
import io.milvus.param.collection.GetLoadingProgressParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.control.GetCompactionPlansParam;
import io.milvus.param.control.GetCompactionStateParam;
import io.milvus.param.control.GetFlushStateParam;
import io.milvus.param.control.GetMetricsParam;
import io.milvus.param.control.GetPersistentSegmentInfoParam;
import io.milvus.param.control.GetQuerySegmentInfoParam;
import io.milvus.param.control.GetReplicasParam;
import io.milvus.param.control.LoadBalanceParam;
import io.milvus.param.control.ManualCompactParam;
import io.milvus.param.credential.CreateCredentialParam;
import io.milvus.param.credential.DeleteCredentialParam;
import io.milvus.param.credential.ListCredUsersParam;
import io.milvus.param.credential.UpdateCredentialParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.param.index.GetIndexBuildProgressParam;
import io.milvus.param.index.GetIndexStateParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.DropPartitionParam;
import io.milvus.param.partition.GetPartitionStatisticsParam;
import io.milvus.param.partition.HasPartitionParam;
import io.milvus.param.partition.LoadPartitionsParam;
import io.milvus.param.partition.ReleasePartitionsParam;
import io.milvus.param.partition.ShowPartitionsParam;
import io.milvus.param.role.AddUserToRoleParam;
import io.milvus.param.role.CreateRoleParam;
import io.milvus.param.role.DropRoleParam;
import io.milvus.param.role.GrantRolePrivilegeParam;
import io.milvus.param.role.RemoveUserFromRoleParam;
import io.milvus.param.role.RevokeRolePrivilegeParam;
import io.milvus.param.role.SelectGrantForRoleAndObjectParam;
import io.milvus.param.role.SelectGrantForRoleParam;
import io.milvus.param.role.SelectRoleParam;
import io.milvus.param.role.SelectUserParam;
import io.milvus.response.DescCollResponseWrapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMilvusGrpcClient
implements MilvusClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMilvusGrpcClient.class);

    protected abstract MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub();

    protected abstract MilvusServiceGrpc.MilvusServiceFutureStub futureStub();

    protected abstract boolean clientIsReady();

    private List<KeyValuePair> assembleKvPair(Map<String, String> sourceMap) {
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        if (MapUtils.isNotEmpty(sourceMap)) {
            sourceMap.forEach((key, value) -> {
                KeyValuePair kv = KeyValuePair.newBuilder().setKey((String)key).setValue((String)value).build();
                result.add(kv);
            });
        }
        return result;
    }

    private void waitForLoadingCollection(String collectionName, List<String> partitionNames, long waitingInterval, long timeout) throws IllegalResponseException {
        block17: {
            long tsBegin = System.currentTimeMillis();
            if (partitionNames == null || partitionNames.isEmpty()) {
                ShowCollectionsRequest showCollectionRequest = ShowCollectionsRequest.newBuilder().addCollectionNames(collectionName).setType(ShowType.InMemory).build();
                while (true) {
                    long tsNow;
                    if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                        this.logWarning("Waiting load thread is timeout, loading process may not be finished", new Object[0]);
                        break block17;
                    }
                    ShowCollectionsResponse response = this.blockingStub().showCollections(showCollectionRequest);
                    int namesCount = response.getCollectionNamesCount();
                    int percentagesCount = response.getInMemoryPercentagesCount();
                    if (namesCount != 1) {
                        throw new IllegalResponseException("ShowCollectionsResponse is illegal. Collection count: " + namesCount);
                    }
                    if (namesCount != percentagesCount) {
                        String msg = "ShowCollectionsResponse is illegal. Collection count: " + namesCount + " memory percentages count: " + percentagesCount;
                        throw new IllegalResponseException(msg);
                    }
                    long percentage = response.getInMemoryPercentages(0);
                    String responseCollection = response.getCollectionNames(0);
                    if (responseCollection.compareTo(collectionName) == 0 && percentage >= 100L) break block17;
                    try {
                        this.logDebug("Waiting load, interval: {} ms, percentage: {}%", waitingInterval, percentage);
                        TimeUnit.MILLISECONDS.sleep(waitingInterval);
                    }
                    catch (InterruptedException e) {
                        this.logWarning("Waiting load thread is interrupted, loading process may not be finished", new Object[0]);
                        break block17;
                    }
                }
            }
            ShowPartitionsRequest showPartitionsRequest = ShowPartitionsRequest.newBuilder().setCollectionName(collectionName).addAllPartitionNames(partitionNames).setType(ShowType.InMemory).build();
            while (true) {
                int percentagesCount;
                long tsNow;
                if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                    this.logWarning("Waiting load thread is timeout, loading process may not be finished", new Object[0]);
                    break;
                }
                ShowPartitionsResponse response = this.blockingStub().showPartitions(showPartitionsRequest);
                int namesCount = response.getPartitionNamesCount();
                if (namesCount != (percentagesCount = response.getInMemoryPercentagesCount())) {
                    String msg = "ShowPartitionsResponse is illegal. Partition count: " + namesCount + " memory percentages count: " + percentagesCount;
                    throw new IllegalResponseException(msg);
                }
                HashMap<String, Long> percentages = new HashMap<String, Long>();
                for (int i = 0; i < response.getInMemoryPercentagesCount(); ++i) {
                    percentages.put(response.getPartitionNames(i), response.getInMemoryPercentages(i));
                }
                String partitionNoMemState = "";
                String partitionNotFullyLoad = "";
                boolean allLoaded = true;
                for (String name : partitionNames) {
                    if (!percentages.containsKey(name)) {
                        allLoaded = false;
                        partitionNoMemState = name;
                        break;
                    }
                    if ((Long)percentages.get(name) >= 100L) continue;
                    allLoaded = false;
                    partitionNotFullyLoad = name;
                    break;
                }
                if (allLoaded) break;
                try {
                    String msg = "Waiting load, interval: " + waitingInterval + "ms.";
                    if (!partitionNoMemState.isEmpty()) {
                        msg = msg + "Partition " + partitionNoMemState + " has no memory state.";
                    }
                    if (!partitionNotFullyLoad.isEmpty()) {
                        msg = msg + "Partition " + partitionNotFullyLoad + " has not fully loaded.";
                    }
                    this.logDebug(msg, new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(waitingInterval);
                }
                catch (InterruptedException e) {
                    this.logWarning("Waiting load thread is interrupted, load process may not be finished", new Object[0]);
                    break;
                }
            }
        }
    }

    private void waitForFlush(FlushResponse flushResponse, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        Map<String, LongArray> collectionSegIDs = flushResponse.getCollSegIDsMap();
        collectionSegIDs.forEach((collectionName, segmentIDs) -> {
            while (segmentIDs.getDataCount() > 0) {
                String msg;
                long tsNow = System.currentTimeMillis();
                if (tsNow - tsBegin >= timeout * 1000L) {
                    this.logWarning("Waiting flush thread is timeout, flush process may not be finished", new Object[0]);
                    break;
                }
                GetFlushStateRequest getFlushStateRequest = GetFlushStateRequest.newBuilder().addAllSegmentIDs(segmentIDs.getDataList()).build();
                GetFlushStateResponse response = this.blockingStub().getFlushState(getFlushStateRequest);
                if (response.getFlushed()) {
                    msg = segmentIDs.getDataCount() + " segments of " + collectionName + " has been flushed.";
                    this.logDebug(msg, new Object[0]);
                    break;
                }
                try {
                    msg = "Waiting flush for " + collectionName + ", interval: " + waitingInterval + "ms. ";
                    this.logDebug(msg, new Object[0]);
                    TimeUnit.MILLISECONDS.sleep(waitingInterval);
                }
                catch (InterruptedException e) {
                    this.logWarning("Waiting flush thread is interrupted, flush process may not be finished", new Object[0]);
                    break;
                }
            }
        });
    }

    private R<Boolean> waitForIndex(String collectionName, String indexName, String fieldName, long waitingInterval, long timeout) {
        long tsBegin = System.currentTimeMillis();
        while (true) {
            String msg;
            long tsNow;
            if ((tsNow = System.currentTimeMillis()) - tsBegin >= timeout * 1000L) {
                String msg2 = "Waiting index thread is timeout, index process may not be finished";
                this.logWarning(msg2, new Object[0]);
                return R.failed(R.Status.UnexpectedError, msg2);
            }
            DescribeIndexRequest request = DescribeIndexRequest.newBuilder().setCollectionName(collectionName).setIndexName(indexName).build();
            DescribeIndexResponse response = this.blockingStub().describeIndex(request);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return R.failed(response.getStatus().getErrorCode(), response.getStatus().getReason());
            }
            if (response.getIndexDescriptionsList().size() == 0) {
                return R.failed(R.Status.UnexpectedError, response.getStatus().getReason());
            }
            IndexDescription index = response.getIndexDescriptionsList().stream().filter(x -> x.getFieldName().equals(fieldName)).findFirst().orElse(response.getIndexDescriptions(0));
            if (index.getState() == IndexState.Finished) {
                return R.success(true);
            }
            if (index.getState() == IndexState.Failed) {
                msg = "Get index state failed: " + index.getState().toString();
                this.logError(msg, new Object[0]);
                return R.failed(R.Status.UnexpectedError, msg);
            }
            try {
                msg = "Waiting index, interval: " + waitingInterval + "ms. ";
                this.logDebug(msg, new Object[0]);
                TimeUnit.MILLISECONDS.sleep(waitingInterval);
            }
            catch (InterruptedException e) {
                String msg3 = "Waiting index thread is interrupted, index process may not be finished";
                this.logWarning(msg3, new Object[0]);
                return R.failed(R.Status.Success, msg3);
            }
        }
    }

    private <T> R<T> failedStatus(String requestName, Status status) {
        String reason = status.getReason();
        if (reason == null || reason.isEmpty()) {
            reason = "error code: " + status.getErrorCode().toString();
        }
        this.logError(requestName + " failed:\n{}", reason);
        return R.failed(R.Status.valueOf(status.getErrorCode().getNumber()), reason);
    }

    @Override
    public R<Boolean> hasCollection(@NonNull HasCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            HasCollectionRequest hasCollectionRequest = HasCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            BoolResponse response = this.blockingStub().hasCollection(hasCollectionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("HasCollectionRequest successfully!", new Object[0]);
                Boolean value = Optional.of(response).map(BoolResponse::getValue).orElse(false);
                return R.success(value);
            }
            return this.failedStatus("HasCollectionRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("HasCollectionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("HasCollectionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createCollection(@NonNull CreateCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CollectionSchema.Builder collectionSchemaBuilder = CollectionSchema.newBuilder();
            collectionSchemaBuilder.setName(requestParam.getCollectionName()).setDescription(requestParam.getDescription());
            long fieldID = 0L;
            for (FieldType fieldType : requestParam.getFieldTypes()) {
                FieldSchema.Builder fieldSchemaBuilder = FieldSchema.newBuilder().setFieldID(fieldID).setName(fieldType.getName()).setIsPrimaryKey(fieldType.isPrimaryKey()).setDescription(fieldType.getDescription()).setDataType(fieldType.getDataType()).setAutoID(fieldType.isAutoID());
                List<KeyValuePair> typeParamsList = this.assembleKvPair(fieldType.getTypeParams());
                if (CollectionUtils.isNotEmpty(typeParamsList)) {
                    typeParamsList.forEach(fieldSchemaBuilder::addTypeParams);
                }
                collectionSchemaBuilder.addFields(fieldSchemaBuilder.build());
                ++fieldID;
            }
            CreateCollectionRequest createCollectionRequest = CreateCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setShardsNum(requestParam.getShardsNum()).setSchema(collectionSchemaBuilder.build().toByteString()).build();
            Status response = this.blockingStub().createCollection(createCollectionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("CreateCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("CreateCollectionRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropCollection(@NonNull DropCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropCollectionRequest dropCollectionRequest = DropCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            Status response = this.blockingStub().dropCollection(dropCollectionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("DropCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("DropCollectionRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("DropCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadCollection(@NonNull LoadCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            LoadCollectionRequest loadCollectionRequest = LoadCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setReplicaNumber(requestParam.getReplicaNumber()).build();
            Status response = this.blockingStub().loadCollection(loadCollectionRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
            }
            if (requestParam.isSyncLoad()) {
                this.waitForLoadingCollection(requestParam.getCollectionName(), null, requestParam.getSyncLoadWaitingInterval(), requestParam.getSyncLoadWaitingTimeout());
            }
            this.logDebug("LoadCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("LoadCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (IllegalResponseException e) {
            this.logError("LoadCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed(e);
        }
        catch (Exception e) {
            this.logError("LoadCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> releaseCollection(@NonNull ReleaseCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ReleaseCollectionRequest releaseCollectionRequest = ReleaseCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            Status response = this.blockingStub().releaseCollection(releaseCollectionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("ReleaseCollectionRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("ReleaseCollectionRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("ReleaseCollectionRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ReleaseCollectionRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeCollectionResponse> describeCollection(@NonNull DescribeCollectionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DescribeCollectionRequest describeCollectionRequest = DescribeCollectionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            DescribeCollectionResponse response = this.blockingStub().describeCollection(describeCollectionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("DescribeCollectionRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("DescribeCollectionRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("DescribeCollectionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DescribeCollectionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetCollectionStatisticsResponse> getCollectionStatistics(@NonNull GetCollectionStatisticsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<FlushResponse> response;
            if (requestParam.isFlushCollection() && (response = this.flush(FlushParam.newBuilder().addCollectionName(requestParam.getCollectionName()).withSyncFlush(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(R.Status.valueOf(response.getStatus()), response.getMessage());
            }
            GetCollectionStatisticsRequest getCollectionStatisticsRequest = GetCollectionStatisticsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetCollectionStatisticsResponse response2 = this.blockingStub().getCollectionStatistics(getCollectionStatisticsRequest);
            if (response2.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetCollectionStatisticsRequest successfully!", new Object[0]);
                return R.success(response2);
            }
            return this.failedStatus("GetCollectionStatisticsRequest", response2.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetCollectionStatisticsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetCollectionStatisticsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ShowCollectionsResponse> showCollections(@NonNull ShowCollectionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ShowCollectionsRequest showCollectionsRequest = ShowCollectionsRequest.newBuilder().addAllCollectionNames(requestParam.getCollectionNames()).setType(requestParam.getShowType()).build();
            ShowCollectionsResponse response = this.blockingStub().showCollections(showCollectionsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("ShowCollectionsRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("ShowCollectionsRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("ShowCollectionsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ShowCollectionsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<FlushResponse> flush(@NonNull FlushParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Flush).build();
            FlushRequest flushRequest = FlushRequest.newBuilder().setBase(msgBase).addAllCollectionNames(requestParam.getCollectionNames()).build();
            FlushResponse response = this.blockingStub().flush(flushRequest);
            if (Objects.equals(requestParam.getSyncFlush(), Boolean.TRUE)) {
                this.waitForFlush(response, requestParam.getSyncFlushWaitingInterval(), requestParam.getSyncFlushWaitingTimeout());
            }
            this.logDebug("FlushRequest successfully! Collection names:{}", requestParam.getCollectionNames());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("FlushRequest RPC failed! Collection names:{}\n{}", requestParam.getCollectionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("FlushRequest failed! Collection names:{}\n{}", requestParam.getCollectionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createPartition(@NonNull CreatePartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CreatePartitionRequest createPartitionRequest = CreatePartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            Status response = this.blockingStub().createPartition(createPartitionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("CreatePartitionRequest successfully! Collection name:{}, partition name:{}", requestParam.getCollectionName(), requestParam.getPartitionName());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("CreatePartitionRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("CreatePartitionRequest RPC failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreatePartitionRequest failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropPartition(@NonNull DropPartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropPartitionRequest dropPartitionRequest = DropPartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            Status response = this.blockingStub().dropPartition(dropPartitionRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("DropPartitionRequest successfully! Collection name:{}, partition name:{}", requestParam.getCollectionName(), requestParam.getPartitionName());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("DropPartitionRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("DropPartitionRequest RPC failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropPartitionRequest failed! Collection name:{}, partition name:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<Boolean> hasPartition(@NonNull HasPartitionParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            HasPartitionRequest hasPartitionRequest = HasPartitionRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            BoolResponse response = this.blockingStub().hasPartition(hasPartitionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("HasPartitionRequest successfully!", new Object[0]);
                Boolean result = response.getValue();
                return R.success(result);
            }
            return this.failedStatus("HasPartitionRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("HasPartitionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("HasPartitionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadPartitions(@NonNull LoadPartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            LoadPartitionsRequest loadPartitionsRequest = LoadPartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setReplicaNumber(requestParam.getReplicaNumber()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            Status response = this.blockingStub().loadPartitions(loadPartitionsRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return R.failed(R.Status.valueOf(response.getErrorCode().getNumber()), response.getReason());
            }
            if (requestParam.isSyncLoad()) {
                this.waitForLoadingCollection(requestParam.getCollectionName(), requestParam.getPartitionNames(), requestParam.getSyncLoadWaitingInterval(), requestParam.getSyncLoadWaitingTimeout());
            }
            this.logDebug("LoadPartitionsRequest successfully! Collection name:{}, partition names:{}", requestParam.getCollectionName(), requestParam.getPartitionNames());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("LoadPartitionsRequest RPC failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (IllegalResponseException e) {
            this.logError("LoadPartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed(e);
        }
        catch (Exception e) {
            this.logError("LoadPartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> releasePartitions(@NonNull ReleasePartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ReleasePartitionsRequest releasePartitionsRequest = ReleasePartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            Status response = this.blockingStub().releasePartitions(releasePartitionsRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("ReleasePartitionsRequest successfully! Collection name:{}, partition names:{}", requestParam.getCollectionName(), requestParam.getPartitionNames());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("ReleasePartitionsRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("ReleasePartitionsRequest RPC failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ReleasePartitionsRequest failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetPartitionStatisticsResponse> getPartitionStatistics(@NonNull GetPartitionStatisticsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<FlushResponse> response;
            if (requestParam.isFlushCollection() && (response = this.flush(FlushParam.newBuilder().addCollectionName(requestParam.getCollectionName()).withSyncFlush(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                return R.failed(R.Status.valueOf(response.getStatus()), response.getMessage());
            }
            GetPartitionStatisticsRequest getPartitionStatisticsRequest = GetPartitionStatisticsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).build();
            GetPartitionStatisticsResponse response2 = this.blockingStub().getPartitionStatistics(getPartitionStatisticsRequest);
            if (response2.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetPartitionStatisticsRequest successfully!", new Object[0]);
                return R.success(response2);
            }
            return this.failedStatus("getPartitionStatistics", response2.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetPartitionStatisticsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetPartitionStatisticsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ShowPartitionsResponse> showPartitions(@NonNull ShowPartitionsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ShowPartitionsRequest showPartitionsRequest = ShowPartitionsRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            ShowPartitionsResponse response = this.blockingStub().showPartitions(showPartitionsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("ShowPartitionsRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("ShowPartitionsRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("ShowPartitionsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ShowPartitionsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createAlias(@NonNull CreateAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CreateAliasRequest createAliasRequest = CreateAliasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setAlias(requestParam.getAlias()).build();
            Status response = this.blockingStub().createAlias(createAliasRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("CreateAliasRequest successfully! Collection name:{}, alias name:{}", requestParam.getCollectionName(), requestParam.getAlias());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("CreateAliasRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateAliasRequest RPC failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateAliasRequest failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropAlias(@NonNull DropAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropAliasRequest dropAliasRequest = DropAliasRequest.newBuilder().setAlias(requestParam.getAlias()).build();
            Status response = this.blockingStub().dropAlias(dropAliasRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("DropAliasRequest successfully! Alias name:{}", requestParam.getAlias());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("DropAliasRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("DropAliasRequest RPC failed! Alias name:{}\n{}", requestParam.getAlias(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropAliasRequest failed! Alias name:{}\n{}", requestParam.getAlias(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> alterAlias(@NonNull AlterAliasParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            AlterAliasRequest alterAliasRequest = AlterAliasRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setAlias(requestParam.getAlias()).build();
            Status response = this.blockingStub().alterAlias(alterAliasRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("AlterAliasRequest successfully! Collection name:{}, alias name:{}", requestParam.getCollectionName(), requestParam.getAlias());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("AlterAliasRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("AlterAliasRequest RPC failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("AlterAliasRequest failed! Collection name:{}, alias name:{}\n{}", requestParam.getCollectionName(), requestParam.getAlias(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createIndex(@NonNull CreateIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<Boolean> res;
            CreateIndexRequest.Builder createIndexRequestBuilder = CreateIndexRequest.newBuilder();
            List<KeyValuePair> extraParamList = this.assembleKvPair(requestParam.getExtraParam());
            if (CollectionUtils.isNotEmpty(extraParamList)) {
                extraParamList.forEach(createIndexRequestBuilder::addExtraParams);
            }
            CreateIndexRequest createIndexRequest = createIndexRequestBuilder.setCollectionName(requestParam.getCollectionName()).setFieldName(requestParam.getFieldName()).setIndexName(requestParam.getIndexName()).build();
            Status response = this.blockingStub().createIndex(createIndexRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("CreateIndexRequest", response);
            }
            if (requestParam.isSyncMode() && (res = this.waitForIndex(requestParam.getCollectionName(), requestParam.getIndexName(), requestParam.getFieldName(), requestParam.getSyncWaitingInterval(), requestParam.getSyncWaitingTimeout())).getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("CreateIndexRequest in sync mode failed:\n{}", res.getMessage());
                return R.failed(R.Status.valueOf(res.getStatus()), res.getMessage());
            }
            this.logDebug("CreateIndexRequest successfully! Collection name:{} Field name:{}", requestParam.getCollectionName(), requestParam.getFieldName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateIndexRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateIndexRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropIndex(@NonNull DropIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropIndexRequest dropIndexRequest = DropIndexRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName()).build();
            Status response = this.blockingStub().dropIndex(dropIndexRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("DropIndexRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("DropIndexRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("DropIndexRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropIndexRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<DescribeIndexResponse> describeIndex(@NonNull DescribeIndexParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName()).build();
            DescribeIndexResponse response = this.blockingStub().describeIndex(describeIndexRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("DescribeIndexRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("DescribeIndexRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("DescribeIndexRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DescribeIndexRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    @Deprecated
    public R<GetIndexStateResponse> getIndexState(@NonNull GetIndexStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetIndexStateRequest getIndexStateRequest = GetIndexStateRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName()).build();
            GetIndexStateResponse response = this.blockingStub().getIndexState(getIndexStateRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetIndexStateRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetIndexStateRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetIndexStateRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetIndexStateRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    @Deprecated
    public R<GetIndexBuildProgressResponse> getIndexBuildProgress(@NonNull GetIndexBuildProgressParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetIndexBuildProgressRequest getIndexBuildProgressRequest = GetIndexBuildProgressRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setIndexName(requestParam.getIndexName()).build();
            GetIndexBuildProgressResponse response = this.blockingStub().getIndexBuildProgress(getIndexBuildProgressRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetIndexBuildProgressRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetIndexBuildProgressRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetIndexBuildProgressRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetIndexBuildProgressRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<MutationResult> delete(@NonNull DeleteParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DeleteRequest deleteRequest = DeleteRequest.newBuilder().setBase(MsgBase.newBuilder().setMsgType(MsgType.Delete).build()).setCollectionName(requestParam.getCollectionName()).setPartitionName(requestParam.getPartitionName()).setExpr(requestParam.getExpr()).build();
            MutationResult response = this.blockingStub().delete(deleteRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("DeleteRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(response);
            }
            return this.failedStatus("DeleteRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("DeleteRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DeleteRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<MutationResult> insert(@NonNull InsertParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<DescribeCollectionResponse> descResp = this.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName()).build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
                return R.failed(R.Status.valueOf(descResp.getStatus()), descResp.getMessage());
            }
            DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp.getData());
            InsertRequest insertRequest = ParamUtils.convertInsertParam(requestParam, wrapper.getFields());
            MutationResult response = this.blockingStub().insert(insertRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("InsertRequest successfully! Collection name:{}", requestParam.getCollectionName());
                return R.success(response);
            }
            return this.failedStatus("InsertRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("InsertRequest RPC failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("InsertRequest failed! Collection name:{}\n{}", requestParam.getCollectionName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<MutationResult>> insertAsync(final InsertParam requestParam) {
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        R<DescribeCollectionResponse> descResp = this.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName()).build());
        if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
            this.logDebug("Failed to describe collection: {}", requestParam.getCollectionName());
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Failed to describe collection")));
        }
        DescCollResponseWrapper wrapper = new DescCollResponseWrapper(descResp.getData());
        InsertRequest insertRequest = ParamUtils.convertInsertParam(requestParam, wrapper.getFields());
        ListenableFuture<MutationResult> response = this.futureStub().insert(insertRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<MutationResult>(){

            public void onSuccess(MutationResult result) {
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("insertAsync successfully! Collection name:{}", new Object[]{requestParam.getCollectionName()});
                } else {
                    AbstractMilvusGrpcClient.this.logError("insertAsync failed! Collection name:{}\n{}", new Object[]{requestParam.getCollectionName(), result.getStatus().getReason()});
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("insertAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<MutationResult, R> transformFunc = results -> {
            if (results.getStatus().getErrorCode() == ErrorCode.Success) {
                return R.success(results);
            }
            return R.failed(R.Status.valueOf(results.getStatus().getErrorCode().getNumber()), results.getStatus().getReason());
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<SearchResults> search(@NonNull SearchParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            SearchRequest searchRequest = ParamUtils.convertSearchParam(requestParam);
            SearchResults response = this.blockingStub().search(searchRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("SearchRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("SearchRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("SearchRequest RPC failed:{}", e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (ParamException e) {
            this.logError("SearchRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<SearchResults>> searchAsync(final SearchParam requestParam) {
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        SearchRequest searchRequest = ParamUtils.convertSearchParam(requestParam);
        ListenableFuture<SearchResults> response = this.futureStub().search(searchRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<SearchResults>(){

            public void onSuccess(SearchResults result) {
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("searchAsync successfully! Collection name:{}", new Object[]{requestParam.getCollectionName()});
                } else {
                    AbstractMilvusGrpcClient.this.logError("searchAsync failed! Collection name:{}\n{}", new Object[]{requestParam.getCollectionName(), result.getStatus().getReason()});
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("searchAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<SearchResults, R> transformFunc = results -> {
            if (results.getStatus().getErrorCode() == ErrorCode.Success) {
                return R.success(results);
            }
            return R.failed(R.Status.valueOf(results.getStatus().getErrorCode().getNumber()), results.getStatus().getReason());
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<QueryResults> query(@NonNull QueryParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            QueryRequest queryRequest = ParamUtils.convertQueryParam(requestParam);
            QueryResults response = this.blockingStub().query(queryRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("QueryRequest successfully!", new Object[0]);
                return R.success(response);
            }
            if (response.getStatus().getErrorCode() == ErrorCode.EmptyCollection) {
                this.logWarning("QueryRequest returns nothing: empty collection or improper expression", new Object[0]);
                return R.failed(ErrorCode.EmptyCollection, "empty collection or improper expression");
            }
            return this.failedStatus("QueryRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("QueryRequest RPC failed:{}", e.getMessage());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("QueryRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public ListenableFuture<R<QueryResults>> queryAsync(final QueryParam requestParam) {
        if (!this.clientIsReady()) {
            return Futures.immediateFuture(R.failed(new ClientNotConnectedException("Client rpc channel is not ready")));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        QueryRequest queryRequest = ParamUtils.convertQueryParam(requestParam);
        ListenableFuture<QueryResults> response = this.futureStub().query(queryRequest);
        Futures.addCallback(response, (FutureCallback)new FutureCallback<QueryResults>(){

            public void onSuccess(QueryResults result) {
                if (result.getStatus().getErrorCode() == ErrorCode.Success) {
                    AbstractMilvusGrpcClient.this.logDebug("queryAsync successfully! Collection name:{}", new Object[]{requestParam.getCollectionName()});
                } else {
                    AbstractMilvusGrpcClient.this.logError("queryAsync failed! Collection name:{}\n{}", new Object[]{requestParam.getCollectionName(), result.getStatus().getReason()});
                }
            }

            public void onFailure(@Nonnull Throwable t) {
                AbstractMilvusGrpcClient.this.logError("queryAsync failed:\n{}", new Object[]{t.getMessage()});
            }
        }, (Executor)MoreExecutors.directExecutor());
        Function<QueryResults, R> transformFunc = results -> {
            if (results.getStatus().getErrorCode() == ErrorCode.Success) {
                return R.success(results);
            }
            return R.failed(R.Status.valueOf(results.getStatus().getErrorCode().getNumber()), results.getStatus().getReason());
        };
        return Futures.transform(response, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public R<GetMetricsResponse> getMetrics(@NonNull GetMetricsParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetMetricsRequest getMetricsRequest = GetMetricsRequest.newBuilder().setRequest(requestParam.getRequest()).build();
            GetMetricsResponse response = this.blockingStub().getMetrics(getMetricsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetMetricsRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetMetricsRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetMetricsRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetMetricsRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetFlushStateResponse> getFlushState(@NonNull GetFlushStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetFlushStateRequest getFlushStateRequest = GetFlushStateRequest.newBuilder().addAllSegmentIDs(requestParam.getSegmentIDs()).build();
            GetFlushStateResponse response = this.blockingStub().getFlushState(getFlushStateRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetFlushState successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetFlushState", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetFlushState RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetFlushState failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetPersistentSegmentInfoResponse> getPersistentSegmentInfo(@NonNull GetPersistentSegmentInfoParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetPersistentSegmentInfoRequest getSegmentInfoRequest = GetPersistentSegmentInfoRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetPersistentSegmentInfoResponse response = this.blockingStub().getPersistentSegmentInfo(getSegmentInfoRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetPersistentSegmentInfoRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetPersistentSegmentInfoRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetPersistentSegmentInfoRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetPersistentSegmentInfoRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetQuerySegmentInfoResponse> getQuerySegmentInfo(@NonNull GetQuerySegmentInfoParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetQuerySegmentInfoRequest getSegmentInfoRequest = GetQuerySegmentInfoRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).build();
            GetQuerySegmentInfoResponse response = this.blockingStub().getQuerySegmentInfo(getSegmentInfoRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetQuerySegmentInfoRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetQuerySegmentInfoRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetQuerySegmentInfoRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetQuerySegmentInfoRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetReplicasResponse> getReplicas(GetReplicasParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<DescribeCollectionResponse> descResp = this.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName()).build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
                return R.failed(R.Status.valueOf(descResp.getStatus()), descResp.getMessage());
            }
            GetReplicasRequest getReplicasRequest = GetReplicasRequest.newBuilder().setCollectionID(descResp.getData().getCollectionID()).setWithShardNodes(requestParam.isWithShardNodes()).build();
            GetReplicasResponse response = this.blockingStub().getReplicas(getReplicasRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetReplicasRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetReplicasRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetReplicasRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetReplicasRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> loadBalance(LoadBalanceParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            LoadBalanceRequest loadBalanceRequest = LoadBalanceRequest.newBuilder().setSrcNodeID(requestParam.getSrcNodeID()).addAllDstNodeIDs(requestParam.getDestNodeIDs()).addAllSealedSegmentIDs(requestParam.getSegmentIDs()).build();
            Status response = this.blockingStub().loadBalance(loadBalanceRequest);
            if (response.getErrorCode() == ErrorCode.Success) {
                this.logDebug("LoadBalanceRequest successfully!", new Object[0]);
                return R.success(new RpcStatus("Success"));
            }
            return this.failedStatus("LoadBalanceRequest", response);
        }
        catch (StatusRuntimeException e) {
            this.logError("LoadBalanceRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("LoadBalanceRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetCompactionStateResponse> getCompactionState(GetCompactionStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetCompactionStateRequest getCompactionStateRequest = GetCompactionStateRequest.newBuilder().setCompactionID(requestParam.getCompactionID()).build();
            GetCompactionStateResponse response = this.blockingStub().getCompactionState(getCompactionStateRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetCompactionStateRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetCompactionStateRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetCompactionStateRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetCompactionStateRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ManualCompactionResponse> manualCompact(ManualCompactParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            R<DescribeCollectionResponse> descResp = this.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(requestParam.getCollectionName()).build());
            if (descResp.getStatus().intValue() != R.Status.Success.getCode()) {
                this.logError("Failed to describe collection: {}", requestParam.getCollectionName());
                return R.failed(R.Status.valueOf(descResp.getStatus()), descResp.getMessage());
            }
            ManualCompactionRequest manualCompactionRequest = ManualCompactionRequest.newBuilder().setCollectionID(descResp.getData().getCollectionID()).build();
            ManualCompactionResponse response = this.blockingStub().manualCompaction(manualCompactionRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("ManualCompactionRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("ManualCompactionRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("ManualCompactionRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ManualCompactionRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetCompactionPlansResponse> getCompactionStateWithPlans(GetCompactionPlansParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetCompactionPlansRequest getCompactionPlansRequest = GetCompactionPlansRequest.newBuilder().setCompactionID(requestParam.getCompactionID()).build();
            GetCompactionPlansResponse response = this.blockingStub().getCompactionStateWithPlans(getCompactionPlansRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetCompactionPlansRequest successfully!", new Object[0]);
                return R.success(response);
            }
            return this.failedStatus("GetCompactionPlansRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetCompactionPlansRequest RPC failed:\n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetCompactionPlansRequest failed:\n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createCredential(CreateCredentialParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CreateCredentialRequest createCredentialRequest = CreateCredentialRequest.newBuilder().setUsername(requestParam.getUsername()).setPassword(this.getBase64EncodeString(requestParam.getPassword())).build();
            Status response = this.blockingStub().createCredential(createCredentialRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("CreateCredential", response);
            }
            this.logDebug("CreateCredential successfully! Username:{}", requestParam.getUsername());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateCredential RPC failed! Username:{}\n{}", requestParam.getUsername(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateCredential failed! Username:{},\n{}", requestParam.getUsername(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> updateCredential(UpdateCredentialParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            UpdateCredentialRequest updateCredentialRequest = UpdateCredentialRequest.newBuilder().setUsername(requestParam.getUsername()).setOldPassword(this.getBase64EncodeString(requestParam.getOldPassword())).setNewPassword(this.getBase64EncodeString(requestParam.getNewPassword())).build();
            Status response = this.blockingStub().updateCredential(updateCredentialRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("UpdateCredential", response);
            }
            this.logDebug("UpdateCredential successfully! Username:{}", requestParam.getUsername());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("UpdateCredential RPC failed! Username:{}\n{}", requestParam.getUsername(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("UpdateCredential failed! Username:{}\n{}", requestParam.getUsername(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> deleteCredential(DeleteCredentialParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DeleteCredentialRequest deleteCredentialRequest = DeleteCredentialRequest.newBuilder().setUsername(requestParam.getUsername()).build();
            Status response = this.blockingStub().deleteCredential(deleteCredentialRequest);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("DeleteCredential", response);
            }
            this.logDebug("DeleteCredential successfully! Username:{}", requestParam.getUsername());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("DeleteCredential RPC failed! Username:{}\n{}", requestParam.getUsername(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DeleteCredential failed! Username:{}\n{}", requestParam.getUsername(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ListCredUsersResponse> listCredUsers(ListCredUsersParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ListCredUsersRequest listCredUsersRequest = ListCredUsersRequest.newBuilder().build();
            ListCredUsersResponse response = this.blockingStub().listCredUsers(listCredUsersRequest);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("ListCredUsers", response.getStatus());
            }
            this.logDebug("ListCredUsers successfully!", new Object[0]);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("ListCredUsers RPC failed! \n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DeleteCredential failed! \n{}", e.getMessage());
            return R.failed(e);
        }
    }

    private String getBase64EncodeString(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public R<RpcStatus> addUserToRole(AddUserToRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            OperateUserRoleRequest request = OperateUserRoleRequest.newBuilder().setUsername(requestParam.getUserName()).setRoleName(requestParam.getRoleName()).setType(OperateUserRoleType.AddUserToRole).build();
            Status response = this.blockingStub().operateUserRole(request);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("AddUserToRole", response);
            }
            this.logDebug("AddUserToRole successfully! Username:{}, RoleName:{}", requestParam.getUserName(), request.getRoleName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("AddUserToRole RPC failed! Username:{} RoleName:{} \n{}", requestParam.getUserName(), requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("AddUserToRole failed! Username:{} RoleName:{} \n{}", requestParam.getUserName(), requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> removeUserFromRole(RemoveUserFromRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            OperateUserRoleRequest request = OperateUserRoleRequest.newBuilder().setUsername(requestParam.getUserName()).setRoleName(requestParam.getRoleName()).setType(OperateUserRoleType.RemoveUserFromRole).build();
            Status response = this.blockingStub().operateUserRole(request);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("RemoveUserFromRole", response);
            }
            this.logDebug("RemoveUserFromRole successfully! Username:{}, RoleName:{}", requestParam.getUserName(), request.getRoleName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("RemoveUserFromRole RPC failed! Username:{} RoleName:{} \n{}", requestParam.getUserName(), requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("RemoveUserFromRole failed! Username:{} RoleName:{} \n{}", requestParam.getUserName(), requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> createRole(CreateRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            CreateRoleRequest request = CreateRoleRequest.newBuilder().setEntity(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).build();
            Status response = this.blockingStub().createRole(request);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("CreateRole", response);
            }
            this.logDebug("CreateRole successfully! RoleName:{}", requestParam.getRoleName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("CreateRole RPC failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CreateRole failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> dropRole(DropRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            DropRoleRequest request = DropRoleRequest.newBuilder().setRoleName(requestParam.getRoleName()).build();
            Status response = this.blockingStub().dropRole(request);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("DropRole", response);
            }
            this.logDebug("DropRole successfully! RoleName:{}", requestParam.getRoleName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("DropRole RPC failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("DropRole failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<SelectRoleResponse> selectRole(SelectRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            SelectRoleRequest request = SelectRoleRequest.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setIncludeUserInfo(requestParam.isIncludeUserInfo()).build();
            SelectRoleResponse response = this.blockingStub().selectRole(request);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("SelectRole", response.getStatus());
            }
            this.logDebug("SelectRole successfully! RoleName:{}", requestParam.getRoleName());
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("SelectRole RPC failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("SelectRole failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<SelectUserResponse> selectUser(SelectUserParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            SelectUserRequest request = SelectUserRequest.newBuilder().setUser(UserEntity.newBuilder().setName(requestParam.getUserName()).build()).setIncludeRoleInfo(requestParam.isIncludeRoleInfo()).build();
            SelectUserResponse response = this.blockingStub().selectUser(request);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("SelectUser", response.getStatus());
            }
            this.logDebug("SelectUser successfully! Request:{}", requestParam);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("SelectUser RPC failed! Request:{} \n{}", requestParam, e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("SelectUser failed! Request:{} \n{}", requestParam, e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> grantRolePrivilege(GrantRolePrivilegeParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            OperatePrivilegeRequest request = OperatePrivilegeRequest.newBuilder().setType(OperatePrivilegeType.Grant).setEntity(GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setObjectName(requestParam.getObjectName()).setObject(ObjectEntity.newBuilder().setName(requestParam.getObject()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(requestParam.getPrivilege()).build()).build()).build()).build();
            Status response = this.blockingStub().operatePrivilege(request);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("GrantRolePrivilege", response);
            }
            this.logDebug("GrantRolePrivilege successfully! RoleName:{}", requestParam.getRoleName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("GrantRolePrivilege RPC failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GrantRolePrivilege failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<RpcStatus> revokeRolePrivilege(RevokeRolePrivilegeParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            OperatePrivilegeRequest request = OperatePrivilegeRequest.newBuilder().setType(OperatePrivilegeType.Revoke).setEntity(GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setObjectName(requestParam.getObjectName()).setObject(ObjectEntity.newBuilder().setName(requestParam.getObject()).build()).setGrantor(GrantorEntity.newBuilder().setPrivilege(PrivilegeEntity.newBuilder().setName(requestParam.getPrivilege()).build()).build()).build()).build();
            Status response = this.blockingStub().operatePrivilege(request);
            if (response.getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("RevokeRolePrivilege", response);
            }
            this.logDebug("RevokeRolePrivilege successfully! RoleName:{}", requestParam.getRoleName());
            return R.success(new RpcStatus("Success"));
        }
        catch (StatusRuntimeException e) {
            this.logError("RevokeRolePrivilege RPC failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("RevokeRolePrivilege failed! RoleName:{} \n{}", requestParam.getRoleName(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<SelectGrantResponse> selectGrantForRole(SelectGrantForRoleParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            SelectGrantRequest request = SelectGrantRequest.newBuilder().setEntity(GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).build()).build();
            SelectGrantResponse response = this.blockingStub().selectGrant(request);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("SelectGrant", response.getStatus());
            }
            this.logDebug("SelectGrantForRole successfully! Request:{},", requestParam);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("SelectGrantForRole RPC failed! Request:{} \n{}", requestParam, e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("SelectGrantForRole failed! Request:{} \n{}", requestParam, e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<SelectGrantResponse> selectGrantForRoleAndObject(SelectGrantForRoleAndObjectParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            SelectGrantRequest request = SelectGrantRequest.newBuilder().setEntity(GrantEntity.newBuilder().setRole(RoleEntity.newBuilder().setName(requestParam.getRoleName()).build()).setObjectName(requestParam.getObjectName()).setObject(ObjectEntity.newBuilder().setName(requestParam.getObject()).build()).build()).build();
            SelectGrantResponse response = this.blockingStub().selectGrant(request);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("SelectGrant", response.getStatus());
            }
            this.logDebug("SelectGrantForRoleAndObject successfully! Request:{},", requestParam);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("SelectGrantForRoleAndObject RPC failed! Request:{} \n{}", requestParam, e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("SelectGrantForRoleAndObject failed! Request:{} \n{}", requestParam, e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ImportResponse> bulkInsert(BulkInsertParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ImportResponse response;
            List<KeyValuePair> options;
            ImportRequest.Builder importRequest = ImportRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllFiles(requestParam.getFiles());
            if (StringUtils.isNotEmpty((CharSequence)requestParam.getPartitionName())) {
                importRequest.setPartitionName(requestParam.getPartitionName());
            }
            if (CollectionUtils.isNotEmpty(options = this.assembleKvPair(requestParam.getOptions()))) {
                options.forEach(importRequest::addOptions);
            }
            if ((response = this.blockingStub().import_(importRequest.build())).getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("BulkInsert", response.getStatus());
            }
            this.logDebug("BulkInsert successfully!", new Object[0]);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("BulkInsert RPC failed! \n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("BulkInsert failed! \n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetImportStateResponse> getBulkInsertState(GetBulkInsertStateParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetImportStateRequest getImportStateRequest = GetImportStateRequest.newBuilder().setTask(requestParam.getTask()).build();
            GetImportStateResponse response = this.blockingStub().getImportState(getImportStateRequest);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("GetBulkInsertState", response.getStatus());
            }
            this.logDebug("GetBulkInsertState successfully!", new Object[0]);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("GetBulkInsertState RPC failed! \n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetBulkInsertState failed! \n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<ListImportTasksResponse> listBulkInsertTasks(ListBulkInsertTasksParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            ListImportTasksRequest listImportTasksRequest = ListImportTasksRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).setLimit(requestParam.getLimit()).build();
            ListImportTasksResponse response = this.blockingStub().listImportTasks(listImportTasksRequest);
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("ListBulkInsertTasks", response.getStatus());
            }
            this.logDebug("ListBulkInsertTasks successfully!", new Object[0]);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("ListBulkInsertTasks RPC failed! \n{}", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("ListBulkInsertTasks failed! \n{}", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetLoadingProgressResponse> getLoadingProgress(GetLoadingProgressParam requestParam) {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        this.logInfo(requestParam.toString(), new Object[0]);
        try {
            GetLoadingProgressRequest releasePartitionsRequest = GetLoadingProgressRequest.newBuilder().setCollectionName(requestParam.getCollectionName()).addAllPartitionNames(requestParam.getPartitionNames()).build();
            GetLoadingProgressResponse response = this.blockingStub().getLoadingProgress(releasePartitionsRequest);
            if (response.getStatus().getErrorCode() == ErrorCode.Success) {
                this.logDebug("GetLoadingProgressParam successfully! Collection name:{}, partition names:{}", requestParam.getCollectionName(), requestParam.getPartitionNames());
                return R.success(response);
            }
            return this.failedStatus("ReleasePartitionsRequest", response.getStatus());
        }
        catch (StatusRuntimeException e) {
            this.logError("GetLoadingProgressParam RPC failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetLoadingProgressParam failed! Collection name:{}, partition names:{}\n{}", requestParam.getCollectionName(), requestParam.getPartitionNames(), e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<CheckHealthResponse> checkHealth() {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        try {
            CheckHealthResponse response = this.blockingStub().checkHealth(CheckHealthRequest.newBuilder().build());
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("SelectGrant", response.getStatus());
            }
            this.logDebug("CheckHealth successfully!", new Object[0]);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("CheckHealth RPC failed!", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("CheckHealth failed! ", e.getMessage());
            return R.failed(e);
        }
    }

    @Override
    public R<GetVersionResponse> getVersion() {
        if (!this.clientIsReady()) {
            return R.failed(new ClientNotConnectedException("Client rpc channel is not ready"));
        }
        try {
            GetVersionResponse response = this.blockingStub().getVersion(GetVersionRequest.newBuilder().build());
            if (response.getStatus().getErrorCode() != ErrorCode.Success) {
                return this.failedStatus("SelectGrant", response.getStatus());
            }
            this.logDebug("GetVersion successfully!", new Object[0]);
            return R.success(response);
        }
        catch (StatusRuntimeException e) {
            this.logError("GetVersion RPC failed!", e.getStatus().toString());
            return R.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logError("GetVersion failed! ", e.getMessage());
            return R.failed(e);
        }
    }

    private void logDebug(String msg, Object ... params) {
        logger.debug(msg, params);
    }

    private void logInfo(String msg, Object ... params) {
        logger.info(msg, params);
    }

    private void logWarning(String msg, Object ... params) {
        logger.warn(msg, params);
    }

    private void logError(String msg, Object ... params) {
        logger.error(msg, params);
    }
}

