/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.utils;

import io.milvus.bulkwriter.common.utils.V2AdapterUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class ParquetUtils {
    private static void setMessageType(Types.MessageTypeBuilder builder, PrimitiveType.PrimitiveTypeName primitiveName, LogicalTypeAnnotation logicType, CreateCollectionReq.FieldSchema field, boolean isListType) {
        if (isListType) {
            if (logicType == null) {
                builder.optionalList().optionalElement(primitiveName).named(field.getName());
            } else {
                ((Types.BaseListBuilder.ElementBuilder)builder.optionalList().optionalElement(primitiveName).as(logicType)).named(field.getName());
            }
        } else if (logicType == null) {
            builder.optional(primitiveName).named(field.getName());
        } else {
            ((Types.PrimitiveBuilder)builder.optional(primitiveName).as(logicType)).named(field.getName());
        }
    }

    public static MessageType parseCollectionSchema(CreateCollectionReq.CollectionSchema collectionSchema) {
        List fields = collectionSchema.getFieldSchemaList();
        List<String> outputFieldNames = V2AdapterUtils.getOutputFieldNames(collectionSchema);
        Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
        for (CreateCollectionReq.FieldSchema field : fields) {
            if (field.getIsPrimaryKey().booleanValue() && field.getAutoID().booleanValue() || outputFieldNames.contains(field.getName())) continue;
            switch (field.getDataType()) {
                case FloatVector: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.FLOAT, null, field, true);
                    break;
                }
                case BinaryVector: 
                case Float16Vector: 
                case BFloat16Vector: 
                case Int8Vector: {
                    boolean isSigned = field.getDataType() == DataType.Int8Vector;
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)8, (boolean)isSigned), field, true);
                    break;
                }
                case Array: {
                    ParquetUtils.fillArrayType(messageTypeBuilder, field);
                    break;
                }
                case Int64: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT64, null, field, false);
                    break;
                }
                case VarChar: 
                case Geometry: 
                case Timestamptz: 
                case JSON: 
                case SparseFloatVector: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), field, false);
                    break;
                }
                case Int8: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)8, (boolean)true), field, false);
                    break;
                }
                case Int16: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)16, (boolean)true), field, false);
                    break;
                }
                case Int32: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, null, field, false);
                    break;
                }
                case Float: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.FLOAT, null, field, false);
                    break;
                }
                case Double: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.DOUBLE, null, field, false);
                    break;
                }
                case Bool: {
                    ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.BOOLEAN, null, field, false);
                }
            }
        }
        if (collectionSchema.isEnableDynamicField()) {
            ((Types.PrimitiveBuilder)messageTypeBuilder.optional(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("$meta");
        }
        return messageTypeBuilder.named("schema");
    }

    private static void fillArrayType(Types.MessageTypeBuilder messageTypeBuilder, CreateCollectionReq.FieldSchema field) {
        switch (field.getElementType()) {
            case Int64: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT64, null, field, true);
                break;
            }
            case VarChar: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), field, true);
                break;
            }
            case Int8: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)8, (boolean)true), field, true);
                break;
            }
            case Int16: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)16, (boolean)true), field, true);
                break;
            }
            case Int32: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.INT32, null, field, true);
                break;
            }
            case Float: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.FLOAT, null, field, true);
                break;
            }
            case Double: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.DOUBLE, null, field, true);
                break;
            }
            case Bool: {
                ParquetUtils.setMessageType(messageTypeBuilder, PrimitiveType.PrimitiveTypeName.BOOLEAN, null, field, true);
            }
        }
    }

    public static Configuration getParquetConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set("fs.file.impl.disable.cache", "true");
        return configuration;
    }
}

