/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class StageManagerParam {
    private final String cloudEndpoint;
    private final String apiKey;

    private StageManagerParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.cloudEndpoint = builder.cloudEndpoint;
        this.apiKey = builder.apiKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCloudEndpoint() {
        return this.cloudEndpoint;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String toString() {
        return "StageManagerParam(cloudEndpoint=" + this.getCloudEndpoint() + ", apiKey=" + this.getApiKey() + ")";
    }

    public static final class Builder {
        private String cloudEndpoint;
        private String apiKey;

        private Builder() {
        }

        public Builder withCloudEndpoint(@NotNull String cloudEndpoint) {
            this.cloudEndpoint = cloudEndpoint;
            return this;
        }

        public Builder withApiKey(@NotNull String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public StageManagerParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString((String)this.cloudEndpoint, (String)"cloudEndpoint");
            ParamUtils.CheckNullEmptyString((String)this.apiKey, (String)"apiKey");
            return new StageManagerParam(this);
        }
    }
}

