/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import io.milvus.bulkwriter.common.clientenum.ConnectType;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class StageFileManagerParam {
    private final String cloudEndpoint;
    private final String apiKey;
    private final String stageName;
    private final ConnectType connectType;

    private StageFileManagerParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.cloudEndpoint = builder.cloudEndpoint;
        this.apiKey = builder.apiKey;
        this.stageName = builder.stageName;
        this.connectType = builder.connectType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCloudEndpoint() {
        return this.cloudEndpoint;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getStageName() {
        return this.stageName;
    }

    public ConnectType getConnectType() {
        return this.connectType;
    }

    public String toString() {
        return "StageFileManagerParam(cloudEndpoint=" + this.getCloudEndpoint() + ", apiKey=" + this.getApiKey() + ", stageName=" + this.getStageName() + ", connectType=" + (Object)((Object)this.getConnectType()) + ")";
    }

    public static final class Builder {
        private String cloudEndpoint;
        private String apiKey;
        private String stageName;
        private ConnectType connectType = ConnectType.AUTO;

        private Builder() {
        }

        public Builder withCloudEndpoint(@NotNull String cloudEndpoint) {
            this.cloudEndpoint = cloudEndpoint;
            return this;
        }

        public Builder withApiKey(@NotNull String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder withStageName(@NotNull String stageName) {
            this.stageName = stageName;
            return this;
        }

        public Builder withConnectType(@NotNull ConnectType connectType) {
            this.connectType = connectType;
            return this;
        }

        public StageFileManagerParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString((String)this.cloudEndpoint, (String)"cloudEndpoint");
            ParamUtils.CheckNullEmptyString((String)this.apiKey, (String)"apiKey");
            ParamUtils.CheckNullEmptyString((String)this.stageName, (String)"stageName");
            return new StageFileManagerParam(this);
        }
    }
}

