/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.utils.V2AdapterUtils;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class StageBulkWriterParam {
    private final CreateCollectionReq.CollectionSchema collectionSchema;
    private final String remotePath;
    private final long chunkSize;
    private final BulkFileType fileType;
    private final Map<String, Object> config;
    private final String cloudEndpoint;
    private final String apiKey;
    private final String stageName;

    private StageBulkWriterParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionSchema = builder.collectionSchema;
        this.remotePath = builder.remotePath;
        this.chunkSize = builder.chunkSize;
        this.fileType = builder.fileType;
        this.config = builder.config;
        this.cloudEndpoint = builder.cloudEndpoint;
        this.apiKey = builder.apiKey;
        this.stageName = builder.stageName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CreateCollectionReq.CollectionSchema getCollectionSchema() {
        return this.collectionSchema;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public BulkFileType getFileType() {
        return this.fileType;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String getCloudEndpoint() {
        return this.cloudEndpoint;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getStageName() {
        return this.stageName;
    }

    public String toString() {
        return "StageBulkWriterParam(collectionSchema=" + this.getCollectionSchema() + ", remotePath=" + this.getRemotePath() + ", chunkSize=" + this.getChunkSize() + ", fileType=" + (Object)((Object)this.getFileType()) + ", config=" + this.getConfig() + ", cloudEndpoint=" + this.getCloudEndpoint() + ", apiKey=" + this.getApiKey() + ", stageName=" + this.getStageName() + ")";
    }

    public static final class Builder {
        private CreateCollectionReq.CollectionSchema collectionSchema;
        private String remotePath;
        private long chunkSize = 0x8000000L;
        private BulkFileType fileType = BulkFileType.PARQUET;
        private Map<String, Object> config = new HashMap<String, Object>();
        private String cloudEndpoint;
        private String apiKey;
        private String stageName;

        private Builder() {
        }

        public Builder withCollectionSchema(@NonNull CollectionSchemaParam collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = V2AdapterUtils.convertV1Schema(collectionSchema);
            return this;
        }

        public Builder withCollectionSchema(@NonNull CreateCollectionReq.CollectionSchema collectionSchema) {
            if (collectionSchema == null) {
                throw new NullPointerException("collectionSchema is marked non-null but is null");
            }
            this.collectionSchema = collectionSchema;
            return this;
        }

        public Builder withRemotePath(@NonNull String remotePath) {
            if (remotePath == null) {
                throw new NullPointerException("remotePath is marked non-null but is null");
            }
            this.remotePath = remotePath;
            return this;
        }

        public Builder withChunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder withFileType(@NonNull BulkFileType fileType) {
            if (fileType == null) {
                throw new NullPointerException("fileType is marked non-null but is null");
            }
            this.fileType = fileType;
            return this;
        }

        public Builder withConfig(String key, Object val) {
            this.config.put(key, val);
            return this;
        }

        public Builder withCloudEndpoint(@NotNull String cloudEndpoint) {
            this.cloudEndpoint = cloudEndpoint;
            return this;
        }

        public Builder withApiKey(@NotNull String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder withStageName(@NotNull String stageName) {
            this.stageName = stageName;
            return this;
        }

        public StageBulkWriterParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString((String)this.remotePath, (String)"localPath");
            if (this.collectionSchema == null) {
                throw new ParamException("collectionSchema cannot be null");
            }
            return new StageBulkWriterParam(this);
        }
    }
}

