/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;

@FunctionalInterface
public interface DigitsValidator<T>
extends ConstraintValidator<Digits, T> {
    @Override
    default public boolean isValid(@Nullable T value, @NonNull AnnotationValue<Digits> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        BigDecimal bigDecimal;
        if (value == null) {
            return true;
        }
        int intMax = annotationMetadata.get((CharSequence)"integer", Integer.TYPE).orElse(0);
        if (intMax < 0) {
            throw new IllegalArgumentException("The length of the integer part cannot be negative.");
        }
        int fracMax = annotationMetadata.get((CharSequence)"fraction", Integer.TYPE).orElse(0);
        if (fracMax < 0) {
            throw new IllegalArgumentException("The length of the fraction part cannot be negative.");
        }
        try {
            bigDecimal = this.getBigDecimal(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int intLen = bigDecimal.precision() - bigDecimal.scale();
        int fracLen = Math.max(bigDecimal.scale(), 0);
        return intMax >= intLen && fracMax >= fracLen;
    }

    public BigDecimal getBigDecimal(@NonNull T var1);
}

