/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.annotation.InEnum;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;

@Singleton
public class InEnumValidator
implements ConstraintValidator<InEnum, Object> {
    @Override
    public boolean isValid(@Nullable Object value, @NonNull AnnotationValue<InEnum> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String) && !(value instanceof Enum)) {
            return true;
        }
        Class enumClass = annotationMetadata.classValue("value", Enum.class).orElse(null);
        if (enumClass == null) {
            return true;
        }
        if (value instanceof Enum && enumClass.isInstance(value)) {
            return true;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            boolean caseSensitive = annotationMetadata.booleanValue("caseSensitive").orElse(true);
            Enum[] constants = (Enum[])enumClass.getEnumConstants();
            if (constants == null) {
                return true;
            }
            for (Enum constant : constants) {
                String name = constant.name();
                if (!(caseSensitive ? name.equals(stringValue) : name.equalsIgnoreCase(stringValue))) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

