/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.constraints.DecimalMaxValidator;
import io.micronaut.validation.validator.constraints.DecimalMinValidator;
import io.micronaut.validation.validator.constraints.DigitsValidator;
import io.micronaut.validation.validator.constraints.EmailValidator;
import io.micronaut.validation.validator.constraints.InternalConstraintValidators;
import io.micronaut.validation.validator.constraints.PatternValidator;
import io.micronaut.validation.validator.constraints.SizeValidator;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Singleton
@Introspected
public class DefaultConstraintValidators
implements ConstraintValidatorRegistry {
    private final Map<ValidatorKey, ConstraintValidator<?, ?>> validatorCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(10).maximumWeightedCapacity(40L).build();
    @Nullable
    private final BeanContext beanContext;
    private final Map<ValidatorKey, ConstraintValidator<?, ?>> internalValidators;

    public DefaultConstraintValidators() {
        this(null);
    }

    @Inject
    public DefaultConstraintValidators(@Nullable BeanContext beanContext) {
        this.beanContext = beanContext;
        List<Map.Entry<Argument<Object>, ConstraintValidator<?, ?>>> constraintValidators = InternalConstraintValidators.getConstraintValidators();
        HashMap validatorMap = CollectionUtils.newHashMap((int)constraintValidators.size());
        for (Map.Entry<Argument<Object>, ConstraintValidator<?, ?>> entry : constraintValidators) {
            ValidatorKey key;
            Argument<Object> definition = entry.getKey();
            ConstraintValidator<?, ?> constraintValidator = entry.getValue();
            Object[] typeParameters = definition.getTypeParameters();
            if (ArrayUtils.isEmpty((Object[])typeParameters)) continue;
            int len = typeParameters.length;
            if (len == 2) {
                Class targetType = ReflectionUtils.getWrapperType((Class)typeParameters[1].getType());
                key = new ValidatorKey(typeParameters[0].getType(), targetType);
                validatorMap.put(key, constraintValidator);
                continue;
            }
            if (len != 1) continue;
            Class type = typeParameters[0].getType();
            if (constraintValidator instanceof SizeValidator) {
                key = new ValidatorKey(Size.class, type);
                validatorMap.put(key, constraintValidator);
                continue;
            }
            if (constraintValidator instanceof DigitsValidator) {
                key = new ValidatorKey(Digits.class, type);
                validatorMap.put(key, constraintValidator);
                continue;
            }
            if (constraintValidator instanceof DecimalMaxValidator) {
                key = new ValidatorKey(DecimalMax.class, type);
                validatorMap.put(key, constraintValidator);
                continue;
            }
            if (!(constraintValidator instanceof DecimalMinValidator)) continue;
            key = new ValidatorKey(DecimalMin.class, type);
            validatorMap.put(key, constraintValidator);
        }
        validatorMap.put(new ValidatorKey(Pattern.class, CharSequence.class), new PatternValidator());
        validatorMap.put(new ValidatorKey(Email.class, CharSequence.class), new EmailValidator());
        this.internalValidators = validatorMap;
    }

    @Override
    @NonNull
    public <A extends Annotation, T> Optional<ConstraintValidator<A, T>> findConstraintValidator(@NonNull Class<A> constraintType, @NonNull Class<T> targetType) {
        ArgumentUtils.requireNonNull((String)"constraintType", constraintType);
        ArgumentUtils.requireNonNull((String)"targetType", targetType);
        ValidatorKey key = new ValidatorKey(constraintType, targetType);
        targetType = ReflectionUtils.getWrapperType(targetType);
        ConstraintValidator<?, ?> constraintValidator = this.internalValidators.get(key);
        if (constraintValidator != null) {
            return Optional.of(constraintValidator);
        }
        constraintValidator = this.validatorCache.get(key);
        if (constraintValidator != null) {
            return Optional.of(constraintValidator);
        }
        Optional<ConstraintValidator<A, T>> local = this.findInternalConstraintValidator(constraintType, targetType);
        if (local.isPresent()) {
            this.validatorCache.put(key, local.get());
            return local;
        }
        if (this.beanContext != null) {
            Argument argument = Argument.of(ConstraintValidator.class);
            Qualifier qualifier = Qualifiers.byTypeArguments((Class[])new Class[]{constraintType, targetType});
            Optional bean = this.beanContext.findBean(argument, qualifier);
            if (bean.isPresent()) {
                this.validatorCache.put(key, (ConstraintValidator)bean.get());
                return bean;
            }
        } else {
            Optional<ConstraintValidator<A, T>> cv = this.findLocalConstraintValidator(constraintType, targetType);
            if (cv.isPresent()) {
                this.validatorCache.put(key, cv.get());
                return cv;
            }
        }
        this.validatorCache.put(key, ConstraintValidator.VALID);
        return Optional.empty();
    }

    private <A extends Annotation, T> Optional<ConstraintValidator<A, T>> findInternalConstraintValidator(Class<A> constraintType, Class<T> validationType) {
        Class[] finalTypeArguments = new Class[]{constraintType, validationType};
        return this.internalValidators.entrySet().stream().filter(entry -> {
            ValidatorKey k = (ValidatorKey)entry.getKey();
            return TypeArgumentQualifier.areTypesCompatible((Class[])finalTypeArguments, Arrays.asList(k.constraintType, k.targetType));
        }).map(e -> (ConstraintValidator)e.getValue()).findFirst();
    }

    protected <A extends Annotation, T> Optional<ConstraintValidator<A, T>> findLocalConstraintValidator(@NonNull Class<A> constraintType, @NonNull Class<T> targetType) {
        return Optional.empty();
    }

    public record ValidatorKey(@NonNull Class<?> constraintType, @NonNull Class<?> targetType) {
    }
}

