/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.Pattern;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class AbstractPatternValidator<A extends Annotation>
implements ConstraintValidator<A, CharSequence> {
    private static final Pattern.Flag[] ZERO_FLAGS = new Pattern.Flag[0];
    private static final Map<PatternKey, Pattern> COMPUTED_PATTERNS = new ConcurrentHashMap<PatternKey, Pattern>(10);

    AbstractPatternValidator() {
    }

    Pattern getPattern(@NonNull AnnotationValue<?> annotationMetadata, boolean isOptional) {
        Optional regexp = annotationMetadata.get((CharSequence)"regexp", String.class);
        String pattern = isOptional ? regexp.orElse(".*") : (String)regexp.orElseThrow(() -> new ValidationException("No pattern specified"));
        Pattern.Flag[] flags = annotationMetadata.get((CharSequence)"flags", Pattern.Flag[].class).orElse(ZERO_FLAGS);
        if (isOptional && pattern.equals(".*") && flags.length == 0) {
            return null;
        }
        int computedFlag = 0;
        for (Pattern.Flag flag : flags) {
            computedFlag |= flag.getValue();
        }
        PatternKey key = new PatternKey(pattern, computedFlag);
        Pattern regex = COMPUTED_PATTERNS.get(key);
        if (regex == null) {
            try {
                regex = computedFlag != 0 ? Pattern.compile(pattern, computedFlag) : Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid regular expression", e);
            }
            COMPUTED_PATTERNS.put(key, regex);
        }
        return regex;
    }

    private record PatternKey(String pattern, int flags) {
    }
}

