/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.inject.MethodReference;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@Internal
final class ValidationPath
implements Path {
    final Deque<Path.Node> nodes;
    private ContainerContext containerContext = DefaultContainerContext.NONE;
    private final ContextualPath popPath = new ContextualPath(){

        @Override
        public void close() {
            ValidationPath.this.nodes.removeLast();
        }
    };

    ValidationPath(ValidationPath nodes) {
        this.nodes = new LinkedList<Path.Node>(nodes.nodes);
    }

    ValidationPath() {
        this.nodes = new LinkedList<Path.Node>();
    }

    public Iterator<Path.Node> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Path.Node> i = this.nodes.iterator();
        boolean dontAddDot = true;
        while (i.hasNext()) {
            Path.Node node = i.next();
            if (node.getKind() == ElementKind.BEAN) continue;
            if (node.isInIterable()) {
                builder.append('[');
                if (node.getIndex() != null) {
                    builder.append(node.getIndex());
                } else if (node.getKey() != null) {
                    builder.append(node.getKey());
                }
                builder.append(']');
            }
            if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
                if (!i.hasNext()) {
                    builder.append(node.getName());
                }
            } else {
                builder.append(dontAddDot ? "" : ".");
                builder.append(node.getName());
            }
            dontAddDot = false;
        }
        return builder.toString();
    }

    ContextualPath withContainerContext(ContainerContext containerContext) {
        ContainerContext prevContainerContext = this.containerContext;
        this.containerContext = containerContext;
        return () -> {
            this.containerContext = prevContainerContext;
        };
    }

    ContextualPath addBeanNode() {
        return this.addBeanNode(this.containerContext);
    }

    ContextualPath addBeanNode(ContainerContext containerContext) {
        return this.addNode(new DefaultBeanNode(containerContext));
    }

    ContextualPath addPropertyNode(String name) {
        return this.addPropertyNode(name, this.containerContext);
    }

    ContextualPath addPropertyNode(String name, ContainerContext containerContext) {
        return this.addNode(new DefaultPropertyNode(name, containerContext));
    }

    ContextualPath addParameterNode(String name, int index) {
        return this.addNode(new DefaultParameterNode(name, index));
    }

    ContextualPath addCrossParameterNode() {
        return this.addNode(new DefaultCrossParameterNode());
    }

    ContextualPath addReturnValueNode() {
        return this.addNode(new DefaultReturnValueNode());
    }

    ContextualPath addContainerElementNode(String name, ContainerContext containerContext) {
        return this.addNode(new DefaultContainerElementNode(name, containerContext));
    }

    ContextualPath addMethodNode(MethodReference<?, ?> reference) {
        return this.addNode(new DefaultMethodNode(reference));
    }

    private ContextualPath addNode(Path.Node node) {
        this.nodes.add(node);
        ContextualPath contextualPath = this.withContainerContext(DefaultContainerContext.NONE);
        return () -> {
            this.popPath.close();
            contextualPath.close();
        };
    }

    ContextualPath addConstructorNode(final String simpleName, final Argument<?> ... constructorArguments) {
        DefaultConstructorNode node = new DefaultConstructorNode(new MethodReference<Object, Object>(){

            public Argument[] getArguments() {
                return constructorArguments;
            }

            public Method getTargetMethod() {
                return null;
            }

            public ReturnType<Object> getReturnType() {
                return null;
            }

            public Class getDeclaringType() {
                return null;
            }

            public String getMethodName() {
                return simpleName;
            }
        });
        this.nodes.add(node);
        return this.popPath;
    }

    public ContextualPath cascaded() {
        Path.Node last = this.nodes.peekLast();
        if (this.containerContext.containerClass() == null && last != null && last.getKind() == ElementKind.CONTAINER_ELEMENT) {
            DefaultContainerElementNode removed = (DefaultContainerElementNode)this.nodes.removeLast();
            ContainerContext prevContainerContext = this.containerContext;
            this.containerContext = removed.containerContext;
            return () -> {
                this.nodes.add(removed);
                this.containerContext = prevContainerContext;
            };
        }
        return () -> {};
    }

    public Path.Node last() {
        return this.nodes.peekLast();
    }

    public ConstraintTarget getConstraintTarget() {
        DefaultNode node = (DefaultNode)this.nodes.peekLast();
        return node == null ? ConstraintTarget.IMPLICIT : node.getConstraintTarget();
    }

    @Internal
    public record DefaultContainerContext(@Nullable Class<?> containerClass, @Nullable Integer index, @Nullable Object key, boolean isInIterable, @Nullable Integer typeArgumentIndex) implements ContainerContext
    {
        static DefaultContainerContext NONE = new DefaultContainerContext(null, null, null, false, null);

        public static DefaultContainerContext ofIterableContainer(Class<?> containerClass) {
            return new DefaultContainerContext(containerClass, null, null, true, 0);
        }

        public static DefaultContainerContext ofContainer(Class<?> containerClass) {
            return new DefaultContainerContext(containerClass, null, null, false, 0);
        }
    }

    public static interface ContainerContext {
        public static ContainerContext indexed(Class<?> containerClass, int index, Integer typeArgumentIndex) {
            return new DefaultContainerContext(containerClass, index, null, true, typeArgumentIndex);
        }

        public static ContainerContext keyed(Class<?> containerClass, Object key, Integer typeArgumentIndex) {
            return new DefaultContainerContext(containerClass, null, key, true, typeArgumentIndex);
        }

        public static ContainerContext iterable(Class<?> containerClass, Integer typeArgumentIndex) {
            return new DefaultContainerContext(containerClass, null, null, true, typeArgumentIndex);
        }

        public static ContainerContext value(Class<?> containerClass, Integer typeArgumentIndex) {
            return new DefaultContainerContext(containerClass, null, null, false, typeArgumentIndex);
        }

        public Class<?> containerClass();

        public Integer index();

        public Object key();

        public boolean isInIterable();

        public Integer typeArgumentIndex();
    }

    @Internal
    public static interface ContextualPath
    extends AutoCloseable {
        @Override
        public void close();
    }

    static final class DefaultBeanNode
    extends DefaultNode
    implements Path.BeanNode {
        public DefaultBeanNode(ContainerContext containerContext) {
            super(null, containerContext);
        }

        public Class<?> getContainerClass() {
            return this.containerContext.containerClass();
        }

        public Integer getTypeArgumentIndex() {
            return this.containerContext.typeArgumentIndex();
        }

        public ElementKind getKind() {
            return ElementKind.BEAN;
        }
    }

    static final class DefaultPropertyNode
    extends DefaultNode
    implements Path.PropertyNode {
        public DefaultPropertyNode(String name, ContainerContext containerContext) {
            super(name, containerContext);
        }

        public Class<?> getContainerClass() {
            return this.containerContext.containerClass();
        }

        public Integer getTypeArgumentIndex() {
            return this.containerContext.typeArgumentIndex();
        }

        public ElementKind getKind() {
            return ElementKind.PROPERTY;
        }
    }

    static final class DefaultParameterNode
    extends DefaultNode
    implements Path.ParameterNode {
        private final int parameterIndex;

        public DefaultParameterNode(@Nullable String name, int parameterIndex) {
            super(name, DefaultContainerContext.NONE);
            this.parameterIndex = parameterIndex;
        }

        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }
    }

    private static final class DefaultCrossParameterNode
    extends DefaultNode
    implements Path.CrossParameterNode {
        public DefaultCrossParameterNode() {
            super("<cross-parameter>", DefaultContainerContext.NONE);
        }

        public ElementKind getKind() {
            return ElementKind.CROSS_PARAMETER;
        }

        @Override
        public ConstraintTarget getConstraintTarget() {
            return ConstraintTarget.PARAMETERS;
        }
    }

    static final class DefaultReturnValueNode
    extends DefaultNode
    implements Path.ReturnValueNode {
        public DefaultReturnValueNode() {
            super("<return value>", DefaultContainerContext.NONE);
        }

        public ElementKind getKind() {
            return ElementKind.RETURN_VALUE;
        }

        @Override
        public ConstraintTarget getConstraintTarget() {
            return ConstraintTarget.RETURN_VALUE;
        }
    }

    private static final class DefaultContainerElementNode
    extends DefaultNode
    implements Path.ContainerElementNode {
        public DefaultContainerElementNode(@Nullable String name, @NonNull ContainerContext containerContext) {
            super(name, containerContext);
        }

        public Class<?> getContainerClass() {
            return this.containerContext.containerClass();
        }

        public Integer getTypeArgumentIndex() {
            return this.containerContext.typeArgumentIndex();
        }

        @Override
        public boolean isInIterable() {
            return this.containerContext.isInIterable();
        }

        @Override
        public Integer getIndex() {
            return this.containerContext.index();
        }

        @Override
        public Object getKey() {
            return this.containerContext.key();
        }

        public ElementKind getKind() {
            return ElementKind.CONTAINER_ELEMENT;
        }
    }

    static class DefaultMethodNode
    extends DefaultNode
    implements Path.MethodNode {
        private final MethodReference<?, ?> methodReference;

        public DefaultMethodNode(MethodReference<?, ?> methodReference) {
            super(methodReference.getMethodName(), DefaultContainerContext.NONE);
            this.methodReference = methodReference;
        }

        public MethodReference<?, ?> getMethodReference() {
            return this.methodReference;
        }

        public List<Class<?>> getParameterTypes() {
            return Arrays.asList(this.methodReference.getArgumentTypes());
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }

    private static final class DefaultConstructorNode
    extends DefaultMethodNode
    implements Path.ConstructorNode {
        public DefaultConstructorNode(MethodReference<Object, Object> methodReference) {
            super(methodReference);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    static abstract class DefaultNode
    implements Path.Node {
        protected final String name;
        protected final ContainerContext containerContext;

        public DefaultNode(String name, ContainerContext containerContext) {
            this.name = name;
            this.containerContext = containerContext;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIterable() {
            return this.containerContext.isInIterable();
        }

        public Integer getIndex() {
            return this.containerContext.index();
        }

        public Object getKey() {
            return this.containerContext.key();
        }

        public String toString() {
            return this.name;
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            if (nodeType.isInstance(this)) {
                return (T)((Path.Node)nodeType.cast(this));
            }
            throw new ClassCastException("Unexpected type: " + nodeType);
        }

        public ConstraintTarget getConstraintTarget() {
            return ConstraintTarget.IMPLICIT;
        }
    }

    @Internal
    public static class MutableContainerContext
    implements ContainerContext {
        @Nullable
        private Class<?> containerClass;
        @Nullable
        private Integer index;
        @Nullable
        private Object key;
        private boolean isInIterable;
        @Nullable
        private Integer typeArgumentIndex;

        public MutableContainerContext() {
        }

        public MutableContainerContext(ContainerContext containerContext) {
            this.containerClass = containerContext.containerClass();
            this.index = containerContext.index();
            this.key = containerContext.key();
            this.isInIterable = containerContext.isInIterable();
            this.typeArgumentIndex = containerContext.typeArgumentIndex();
        }

        @Override
        public Class<?> containerClass() {
            return this.containerClass;
        }

        @Override
        public Integer index() {
            return this.index;
        }

        @Override
        public Object key() {
            return this.key;
        }

        @Override
        public boolean isInIterable() {
            return this.isInIterable;
        }

        @Override
        public Integer typeArgumentIndex() {
            return this.typeArgumentIndex;
        }

        public void inIterable() {
            this.isInIterable = true;
        }

        public void inContainer(Class<?> containerClass, Integer typeArgumentIndex) {
            this.containerClass = containerClass;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public void atKey(Object key) {
            this.key = key;
        }

        public void atIndex(Integer index) {
            this.index = index;
        }
    }
}

