/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.messages;

import io.micronaut.context.MessageSource;
import io.micronaut.context.StaticMessageSource;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import jakarta.inject.Singleton;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.Locale;

@Singleton
public class DefaultValidationMessages
implements MessageInterpolator {
    private static final char QUOT = '\\';
    private static final char L_BRACE = '{';
    private static final char R_BRACE = '}';
    private static final char DOLL_BRACE = '$';
    private static final String MESSAGE_SUFFIX = ".message";
    private final StaticMessageSource messageSource = new StaticMessageSource();

    public DefaultValidationMessages() {
        this.messageSource.addMessage(AssertTrue.class.getName() + MESSAGE_SUFFIX, "must be true");
        this.messageSource.addMessage(AssertFalse.class.getName() + MESSAGE_SUFFIX, "must be false");
        this.messageSource.addMessage(DecimalMax.class.getName() + MESSAGE_SUFFIX, "must be less than or equal to {value}");
        this.messageSource.addMessage(DecimalMin.class.getName() + MESSAGE_SUFFIX, "must be greater than or equal to {value}");
        this.messageSource.addMessage(Digits.class.getName() + MESSAGE_SUFFIX, "numeric value out of bounds (<{integer} digits>.<{fraction} digits> expected)");
        this.messageSource.addMessage(Email.class.getName() + MESSAGE_SUFFIX, "must be a well-formed email address");
        this.messageSource.addMessage(Future.class.getName() + MESSAGE_SUFFIX, "must be a future date");
        this.messageSource.addMessage(FutureOrPresent.class.getName() + MESSAGE_SUFFIX, "must be a date in the present or in the future");
        this.messageSource.addMessage(Max.class.getName() + MESSAGE_SUFFIX, "must be less than or equal to {value}");
        this.messageSource.addMessage(Min.class.getName() + MESSAGE_SUFFIX, "must be greater than or equal to {value}");
        this.messageSource.addMessage(Negative.class.getName() + MESSAGE_SUFFIX, "must be less than 0");
        this.messageSource.addMessage(NegativeOrZero.class.getName() + MESSAGE_SUFFIX, "must be less than or equal to 0");
        this.messageSource.addMessage(NotBlank.class.getName() + MESSAGE_SUFFIX, "must not be blank");
        this.messageSource.addMessage(NotEmpty.class.getName() + MESSAGE_SUFFIX, "must not be empty");
        this.messageSource.addMessage(NotNull.class.getName() + MESSAGE_SUFFIX, "must not be null");
        this.messageSource.addMessage(Null.class.getName() + MESSAGE_SUFFIX, "must be null");
        this.messageSource.addMessage(Past.class.getName() + MESSAGE_SUFFIX, "must be a past date");
        this.messageSource.addMessage(PastOrPresent.class.getName() + MESSAGE_SUFFIX, "must be a date in the past or in the present");
        this.messageSource.addMessage(Pattern.class.getName() + MESSAGE_SUFFIX, "must match \"{regexp}\"");
        this.messageSource.addMessage(Positive.class.getName() + MESSAGE_SUFFIX, "must be greater than 0");
        this.messageSource.addMessage(PositiveOrZero.class.getName() + MESSAGE_SUFFIX, "must be greater than or equal to 0");
        this.messageSource.addMessage(Size.class.getName() + MESSAGE_SUFFIX, "size must be between {min} and {max}");
        this.messageSource.addMessage(Introspected.class.getName() + MESSAGE_SUFFIX, "Cannot validate {type}. No bean introspection present. Please add @Introspected to the class and ensure Micronaut annotation processing is enabled");
    }

    private String interpolate(@NonNull String template, @NonNull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull((String)"template", (Object)template);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder variableBuilder = new StringBuilder();
        StringBuilder builder = messageBuilder;
        boolean isVariable = false;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '\\' && i + 1 < template.length()) {
                if ((c = template.charAt(++i)) == '{') {
                    builder.append('{');
                    continue;
                }
                if (c == '}') {
                    builder.append('}');
                    continue;
                }
                if (c == '$') {
                    builder.append('$');
                    continue;
                }
                builder.append('\\');
                builder.append(c);
                continue;
            }
            if (c == '{') {
                if (!isVariable) {
                    isVariable = true;
                    builder = variableBuilder;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '}') {
                if (isVariable) {
                    builder = messageBuilder;
                    isVariable = false;
                    String variableName = variableBuilder.toString();
                    variableBuilder.setLength(0);
                    Object variableValue = context.getVariables().get(variableName);
                    if (variableValue == null) {
                        variableValue = this.messageSource.getMessage(variableName, context).orElse(null);
                    }
                    if (variableValue == null) {
                        builder.append('{').append(variableName).append('}');
                        continue;
                    }
                    builder.append(variableValue);
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        return this.interpolate(messageTemplate, context, Locale.ENGLISH);
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(context.getConstraintDescriptor().getAttributes());
        attributes.put("validatedValue", context.getValidatedValue());
        return this.interpolate(messageTemplate, MessageSource.MessageContext.of((Locale)locale, attributes));
    }
}

