/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.extractors;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.validation.validator.extractors.InternalValueExtractors;
import io.micronaut.validation.validator.extractors.UnwrapByDefaultValueExtractor;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.valueextraction.UnwrapByDefault;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Singleton
@Introspected
public class DefaultValueExtractors
implements ValueExtractorRegistry {
    private final Map<Class<?>, ValueExtractor<?>> valueExtractors;
    private final Set<Class<?>> unwrapByDefaultTypes = new HashSet(5);

    public DefaultValueExtractors() {
        this(null);
    }

    @Inject
    protected DefaultValueExtractors(@Nullable BeanContext beanContext) {
        ValueExtractor valueExtractor;
        Collection valueExtractors;
        HashMap<Object, ValueExtractor> extractorMap = new HashMap<Object, ValueExtractor>();
        if (beanContext != null && beanContext.containsBean(ValueExtractor.class) && CollectionUtils.isNotEmpty((Collection)(valueExtractors = beanContext.getBeanRegistrations(ValueExtractor.class)))) {
            for (BeanRegistration reg : valueExtractors) {
                valueExtractor = (ValueExtractor)reg.getBean();
                Object[] typeParameters = reg.getBeanDefinition().getTypeParameters(ValueExtractor.class);
                if (!ArrayUtils.isNotEmpty((Object[])typeParameters)) continue;
                Object targetType = typeParameters[0];
                extractorMap.put(targetType, valueExtractor);
                if (!(valueExtractor instanceof UnwrapByDefaultValueExtractor) && !valueExtractor.getClass().isAnnotationPresent(UnwrapByDefault.class)) continue;
                this.unwrapByDefaultTypes.add((Class<?>)targetType);
            }
        }
        for (Map.Entry<Argument<Object>, ValueExtractor<?>> entry : InternalValueExtractors.getValueExtractors()) {
            Argument<Object> definition = entry.getKey();
            valueExtractor = entry.getValue();
            Class targetType = definition.getFirstTypeVariable().map(TypeInformation::getType).orElse(null);
            extractorMap.put(targetType, valueExtractor);
            if (!(valueExtractor instanceof UnwrapByDefaultValueExtractor) && !valueExtractor.getClass().isAnnotationPresent(UnwrapByDefault.class)) continue;
            this.unwrapByDefaultTypes.add(targetType);
        }
        this.valueExtractors = CollectionUtils.newHashMap((int)extractorMap.size());
        this.valueExtractors.putAll(extractorMap);
    }

    @Override
    public <T> void addValueExtractor(Class<T> targetType, ValueExtractor<T> valueExtractor) {
        this.valueExtractors.put(targetType, valueExtractor);
    }

    @Override
    @NonNull
    public <T> Optional<ValueExtractor<T>> findValueExtractor(@NonNull Class<T> targetType) {
        ValueExtractor<?> valueExtractor = this.valueExtractors.get(targetType);
        if (valueExtractor != null) {
            return Optional.of(valueExtractor);
        }
        return this.valueExtractors.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(targetType)).map(e -> (ValueExtractor)e.getValue()).findFirst();
    }

    @Override
    @NonNull
    public <T> Optional<ValueExtractor<T>> findUnwrapValueExtractor(@NonNull Class<T> targetType) {
        if (this.unwrapByDefaultTypes.contains(targetType)) {
            return Optional.ofNullable(this.valueExtractors.get(targetType));
        }
        return Optional.empty();
    }
}

