/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.validation.ClockProvider;
import jakarta.validation.Constraint;
import java.lang.annotation.Annotation;
import java.util.Optional;

@Indexed(value=ConstraintValidator.class)
@FunctionalInterface
public interface ConstraintValidator<A extends Annotation, T>
extends jakarta.validation.ConstraintValidator<A, T> {
    public static final ConstraintValidator<Annotation, Object> VALID = (value, annotationMetadata, context) -> true;

    public boolean isValid(@Nullable T var1, @NonNull AnnotationValue<A> var2, @NonNull ConstraintValidatorContext var3);

    default public boolean isValid(T value, final jakarta.validation.ConstraintValidatorContext context) {
        return this.isValid(value, new AnnotationValue(Constraint.class.getName()), new ConstraintValidatorContext(){
            private String messageTemplate;
            {
                this.messageTemplate = context.getDefaultConstraintMessageTemplate();
            }

            @Override
            @NonNull
            public ClockProvider getClockProvider() {
                return context.getClockProvider();
            }

            @Override
            @Nullable
            public Object getRootBean() {
                return null;
            }

            @Override
            public void messageTemplate(@Nullable String messageTemplate) {
                this.messageTemplate = messageTemplate;
            }

            public Optional<String> getMessageTemplate() {
                return Optional.ofNullable(this.messageTemplate);
            }
        });
    }
}

