/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.ConversionServiceAware;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.Toggleable;
import io.micronaut.validation.validator.DefaultClockProvider;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.constraints.DefaultConstraintValidators;
import io.micronaut.validation.validator.extractors.DefaultValueExtractors;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import io.micronaut.validation.validator.messages.DefaultValidationMessages;
import jakarta.inject.Inject;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

@ConfigurationProperties(value="micronaut.validator")
public class DefaultValidatorConfiguration
implements ValidatorConfiguration,
Toggleable,
ValidatorContext,
ConversionServiceAware {
    @Nullable
    private ConstraintValidatorRegistry constraintValidatorRegistry;
    @Nullable
    private ValueExtractorRegistry valueExtractorRegistry;
    @Nullable
    private ClockProvider clockProvider;
    @Nullable
    private TraversableResolver traversableResolver;
    @Nullable
    private MessageSource messageSource;
    @Nullable
    private ExecutionHandleLocator executionHandleLocator;
    private ConversionService conversionService = ConversionService.SHARED;
    private BeanIntrospector beanIntrospector = BeanIntrospector.SHARED;
    private boolean enabled = true;

    @Inject
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    @NonNull
    public ConstraintValidatorRegistry getConstraintValidatorRegistry() {
        if (this.constraintValidatorRegistry == null) {
            this.constraintValidatorRegistry = new DefaultConstraintValidators();
        }
        return this.constraintValidatorRegistry;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DefaultValidatorConfiguration setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Inject
    public DefaultValidatorConfiguration setConstraintValidatorRegistry(@Nullable ConstraintValidatorRegistry constraintValidatorRegistry) {
        this.constraintValidatorRegistry = constraintValidatorRegistry;
        return this;
    }

    @Override
    @NonNull
    public ValueExtractorRegistry getValueExtractorRegistry() {
        if (this.valueExtractorRegistry == null) {
            this.valueExtractorRegistry = new DefaultValueExtractors();
        }
        return this.valueExtractorRegistry;
    }

    @Inject
    public DefaultValidatorConfiguration setValueExtractorRegistry(@Nullable ValueExtractorRegistry valueExtractorRegistry) {
        this.valueExtractorRegistry = valueExtractorRegistry;
        return this;
    }

    @Override
    @NonNull
    public ClockProvider getClockProvider() {
        if (this.clockProvider == null) {
            this.clockProvider = new DefaultClockProvider();
        }
        return this.clockProvider;
    }

    @Inject
    public DefaultValidatorConfiguration setClockProvider(@Nullable ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    @Override
    @NonNull
    public TraversableResolver getTraversableResolver() {
        if (this.traversableResolver == null) {
            this.traversableResolver = new TraversableResolver(){

                public boolean isReachable(Object object, Path.Node node, Class<?> rootType, Path path, ElementType elementType) {
                    return true;
                }

                public boolean isCascadable(Object object, Path.Node node, Class<?> rootType, Path path, ElementType elementType) {
                    return true;
                }
            };
        }
        return this.traversableResolver;
    }

    @Inject
    public DefaultValidatorConfiguration setTraversableResolver(@Nullable TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    @Override
    @NonNull
    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            this.messageSource = new DefaultValidationMessages();
        }
        return this.messageSource;
    }

    @Inject
    public DefaultValidatorConfiguration setMessageSource(@Nullable MessageSource messageSource) {
        this.messageSource = messageSource;
        return this;
    }

    @Override
    @NonNull
    public ExecutionHandleLocator getExecutionHandleLocator() {
        if (this.executionHandleLocator == null) {
            this.executionHandleLocator = ExecutionHandleLocator.EMPTY;
        }
        return this.executionHandleLocator;
    }

    @Inject
    public DefaultValidatorConfiguration setExecutionHandleLocator(@Nullable ExecutionHandleLocator executionHandleLocator) {
        this.executionHandleLocator = executionHandleLocator;
        return this;
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        throw new UnsupportedOperationException("Method messageInterpolator(..) not supported");
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        throw new UnsupportedOperationException("Method constraintValidatorFactory(..) not supported");
    }

    public ValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        throw new UnsupportedOperationException("Method parameterNameProvider(..) not supported");
    }

    public ValidatorContext clockProvider(ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    public ValidatorContext addValueExtractor(ValueExtractor<?> extractor) {
        ArrayList<AnnotatedType> annotatedTypes = new ArrayList<AnnotatedType>();
        DefaultValidatorConfiguration.determineValueExtractorDefinitions(annotatedTypes, extractor.getClass());
        if (annotatedTypes.size() != 1) {
            throw new IllegalStateException("Expected to find one annotation type! Got: " + annotatedTypes);
        }
        Class clazz = Argument.of((Type)((AnnotatedType)annotatedTypes.get(0)).getType()).getTypeParameters()[0].getType();
        ValueExtractor<?> v = extractor;
        this.getValueExtractorRegistry().addValueExtractor(clazz, v);
        return this;
    }

    public Validator getValidator() {
        return new DefaultValidator(this);
    }

    @Override
    public BeanIntrospector getBeanIntrospector() {
        return this.beanIntrospector;
    }

    public final void setBeanIntrospector(BeanIntrospector beanIntrospector) {
        this.beanIntrospector = beanIntrospector;
    }

    private static void determineValueExtractorDefinitions(List<AnnotatedType> valueExtractorDefinitions, Class<?> extractorImplementationType) {
        if (!ValueExtractor.class.isAssignableFrom(extractorImplementationType)) {
            return;
        }
        Class<?> superClass = extractorImplementationType.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            DefaultValidatorConfiguration.determineValueExtractorDefinitions(valueExtractorDefinitions, superClass);
        }
        for (Class<?> clazz : extractorImplementationType.getInterfaces()) {
            if (ValueExtractor.class.equals(clazz)) continue;
            DefaultValidatorConfiguration.determineValueExtractorDefinitions(valueExtractorDefinitions, clazz);
        }
        for (AnnotatedElement annotatedElement : extractorImplementationType.getAnnotatedInterfaces()) {
            if (!ValueExtractor.class.equals(DefaultValidatorConfiguration.getClassFromType(annotatedElement.getType()))) continue;
            valueExtractorDefinitions.add((AnnotatedType)annotatedElement);
        }
    }

    public static Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DefaultValidatorConfiguration.getClassFromType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        throw new IllegalArgumentException();
    }
}

