/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.Payload;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ValidateUnwrappedValue;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
class DefaultConstraintDescriptor<T extends Annotation>
implements ConstraintDescriptor<T> {
    private final AnnotationValue<T> annotationValue;
    private final AnnotationMetadata annotationMetadata;
    private final Class<T> type;

    DefaultConstraintDescriptor(AnnotationMetadata annotationMetadata, Class<T> type, AnnotationValue<T> annotationValue) {
        this.annotationValue = annotationValue;
        this.annotationMetadata = annotationMetadata;
        this.type = type;
    }

    public T getAnnotation() {
        return (T)this.annotationMetadata.synthesize(this.type);
    }

    public String getMessageTemplate() {
        return this.annotationValue.stringValue("groups").orElse(null);
    }

    public Set<Class<?>> getGroups() {
        return Arrays.stream(this.annotationValue.classValues("groups")).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Class<? extends Payload>> getPayload() {
        return Arrays.stream(this.annotationValue.classValues("payload")).map(c -> c).collect(Collectors.toUnmodifiableSet());
    }

    public ConstraintTarget getValidationAppliesTo() {
        return ConstraintTarget.IMPLICIT;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return Collections.emptyList();
    }

    public Map<String, Object> getAttributes() {
        return this.annotationValue.getValues().entrySet().stream().collect(Collectors.toMap(entry -> ((CharSequence)entry.getKey()).toString(), Map.Entry::getValue));
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return Collections.emptySet();
    }

    public boolean isReportAsSingleViolation() {
        return false;
    }

    public ValidateUnwrappedValue getValueUnwrapping() {
        return ValidateUnwrappedValue.DEFAULT;
    }

    public Object unwrap(Class type) {
        throw new UnsupportedOperationException("Unwrapping unsupported");
    }
}

