/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.visitor;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Vetoed;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.validation.RequiresValidation;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

@Internal
public class ValidationVisitor
implements TypeElementVisitor<Object, Object> {
    private static final String ANN_CASCADE = "io.micronaut.validation.annotation.ValidatedElement";
    private static final String ANN_CONSTRAINT = "jakarta.validation.Constraint";
    private static final String ANN_VALID = "jakarta.validation.Valid";
    private ClassElement classElement;
    private final Set<Object> visited = new HashSet<Object>();

    public Set<String> getSupportedAnnotationNames() {
        return Set.of("jakarta.validation.*");
    }

    public int getOrder() {
        return 10;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.visited.clear();
        this.classElement = element;
        if (this.classElement.isInterface() && this.classElement.hasAnnotation("jakarta.validation.GroupSequence")) {
            this.classElement.annotate(Introspected.class);
        }
    }

    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        if (this.classElement == null) {
            return;
        }
        if (!this.visited.add(element)) {
            return;
        }
        boolean parametersRequireValidation = this.parametersRequireValidation((MethodElement)element, true);
        boolean returnTypeRequiresValidation = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)element.getReturnType(), true);
        if (returnTypeRequiresValidation || parametersRequireValidation) {
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (this.classElement == null || element.hasStereotype(Vetoed.class)) {
            return;
        }
        if (!this.visited.add(element)) {
            return;
        }
        element.getOverriddenMethods().forEach(m -> this.inheritAnnotationsForMethod(element, (MethodElement)m));
        boolean isPrivate = element.isPrivate();
        boolean isAbstract = element.getOwningType().isInterface() || element.getOwningType().isAbstract();
        boolean requireOnConstraint = isAbstract || !isPrivate;
        boolean parametersRequireValidation = this.parametersRequireValidation(element, requireOnConstraint);
        boolean returnTypeRequiresValidation = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)element.getReturnType(), requireOnConstraint);
        boolean methodAnnotatedForValidation = this.returnTypeRequiresValidation(element, true);
        if (parametersRequireValidation || returnTypeRequiresValidation || methodAnnotatedForValidation) {
            if (isPrivate) {
                throw new ProcessingException((Element)element, "Method annotated for validation but is declared private. Change the method to be non-private in order for AOP advice to be applied.");
            }
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    public void visitField(FieldElement element, VisitorContext context) {
        if (this.classElement == null) {
            return;
        }
        if (!this.visited.add(element)) {
            return;
        }
        if (this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)element, true)) {
            element.annotate(RequiresValidation.class);
            this.classElement.annotate(RequiresValidation.class);
        }
    }

    private boolean parametersRequireValidation(MethodElement element, boolean requireOnConstraint) {
        boolean requiredValidation = false;
        for (ParameterElement parameter : element.getParameters()) {
            boolean requiresValidationForParameter = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)parameter, requireOnConstraint);
            requiredValidation |= requiresValidationForParameter;
        }
        return requiredValidation;
    }

    private boolean returnTypeRequiresValidation(MethodElement e, boolean requireOnConstraint) {
        MutableAnnotationMetadataDelegate methodAnnotationMetadata = e.getMethodAnnotationMetadata();
        return methodAnnotationMetadata.hasStereotype(ANN_VALID) || requireOnConstraint && methodAnnotationMetadata.hasStereotype(ANN_CONSTRAINT);
    }

    private boolean visitElementValidationAndMarkForValidationIfNeeded(TypedElement e, boolean requireOnConstraint) {
        boolean requiresValidation;
        AnnotationMetadata annotationMetadata;
        boolean requiresTypeValidation = this.visitTypedElementValidationAndMarkForValidationIfNeeded(e, requireOnConstraint);
        if (e instanceof ClassElement) {
            ClassElement ce = (ClassElement)e;
            annotationMetadata = ce.getTypeAnnotationMetadata();
        } else {
            annotationMetadata = e.getAnnotationMetadata();
        }
        AnnotationMetadata annotationMetadata2 = annotationMetadata;
        boolean bl = requiresValidation = requireOnConstraint && annotationMetadata2.hasStereotype(ANN_CONSTRAINT) || annotationMetadata2.hasStereotype(ANN_VALID) || requiresTypeValidation;
        if (requiresValidation) {
            try {
                e.annotate(ANN_CASCADE);
                e.annotate(RequiresValidation.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return requiresValidation;
    }

    private boolean visitTypedElementValidationAndMarkForValidationIfNeeded(TypedElement e, boolean requireOnConstraint) {
        boolean requires = false;
        ClassElement genericType = e.getGenericType();
        for (ClassElement typeArgument : genericType.getTypeArguments().values()) {
            boolean requiresForType = this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)typeArgument, requireOnConstraint);
            requires |= requiresForType;
        }
        if (!genericType.equals((Object)e)) {
            requires |= this.visitElementValidationAndMarkForValidationIfNeeded((TypedElement)genericType, requireOnConstraint);
        }
        return requires;
    }

    private void inheritAnnotationsForMethod(MethodElement method, MethodElement parent) {
        ParameterElement[] methodParameters = method.getParameters();
        ParameterElement[] parentParameters = parent.getParameters();
        for (int i = 0; i < methodParameters.length; ++i) {
            this.inheritAnnotationsForParameter((TypedElement)methodParameters[i], (TypedElement)parentParameters[i]);
        }
        this.inheritAnnotationsForParameter((TypedElement)method.getReturnType(), (TypedElement)parent.getReturnType());
    }

    private void inheritAnnotationsForParameter(TypedElement element, TypedElement parentElement) {
        if (!element.getType().equals((Object)parentElement.getType())) {
            return;
        }
        Stream parentAnnotations = Stream.concat(parentElement.getAnnotationNamesByStereotype(ANN_CONSTRAINT).stream(), parentElement.getAnnotationNamesByStereotype(ANN_VALID).stream());
        parentAnnotations.filter(name -> !element.hasAnnotation(name)).flatMap(name -> parentElement.getAnnotationValuesByName(name).stream()).forEach(arg_0 -> ((TypedElement)element).annotate(arg_0));
        Map typeArguments = element.getGenericType().getTypeArguments();
        Map parentTypeArguments = parentElement.getGenericType().getTypeArguments();
        if (typeArguments.size() != parentTypeArguments.size()) {
            return;
        }
        for (Map.Entry entry : typeArguments.entrySet()) {
            this.inheritAnnotationsForParameter((TypedElement)entry.getValue(), (TypedElement)parentTypeArguments.get(entry.getKey()));
        }
    }
}

