/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.PullResponseItem;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;

class LoggedPullImageResultCallback
extends PullImageResultCallback {
    private final Logger logger;
    private final Set<String> allLayers = new HashSet<String>();
    private final Set<String> downloadedLayers = new HashSet<String>();
    private final Set<String> pulledLayers = new HashSet<String>();
    private final Map<String, Long> totalSizes = new HashMap<String, Long>();
    private final Map<String, Long> currentSizes = new HashMap<String, Long>();
    private boolean completed;
    private Instant start;

    LoggedPullImageResultCallback(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onStart(Closeable stream) {
        super.onStart(stream);
        this.start = Instant.now();
        this.logger.info("Starting to pull image");
    }

    @Override
    public void onNext(PullResponseItem item) {
        super.onNext(item);
        String statusLowercase = item.getStatus() != null ? item.getStatus().toLowerCase() : "";
        String id = item.getId();
        if (item.getProgressDetail() != null) {
            this.allLayers.add(id);
        }
        if (statusLowercase.equalsIgnoreCase("download complete")) {
            this.downloadedLayers.add(id);
        }
        if (statusLowercase.equalsIgnoreCase("pull complete")) {
            this.pulledLayers.add(id);
        }
        if (item.getProgressDetail() != null) {
            Long total = item.getProgressDetail().getTotal();
            Long current = item.getProgressDetail().getCurrent();
            if (total != null && total > this.totalSizes.getOrDefault(id, 0L)) {
                this.totalSizes.put(id, total);
            }
            if (current != null && current > this.currentSizes.getOrDefault(id, 0L)) {
                this.currentSizes.put(id, current);
            }
        }
        if (statusLowercase.startsWith("pulling from") || statusLowercase.contains("complete")) {
            long totalSize = this.totalLayerSize();
            long currentSize = this.downloadedLayerSize();
            int pendingCount = this.allLayers.size() - this.downloadedLayers.size();
            String friendlyTotalSize = pendingCount > 0 ? "? MB" : FileUtils.byteCountToDisplaySize(totalSize);
            this.logger.info("Pulling image layers: {} pending, {} downloaded, {} extracted, ({}/{})", String.format("%2d", pendingCount), String.format("%2d", this.downloadedLayers.size()), String.format("%2d", this.pulledLayers.size()), FileUtils.byteCountToDisplaySize(currentSize), friendlyTotalSize);
        }
        if (statusLowercase.contains("complete")) {
            this.completed = true;
        }
    }

    @Override
    public void onComplete() {
        super.onComplete();
        long downloadedLayerSize = this.downloadedLayerSize();
        long duration = Duration.between(this.start, Instant.now()).getSeconds();
        if (this.completed) {
            this.logger.info("Pull complete. {} layers, pulled in {}s (downloaded {} at {}/s)", this.allLayers.size(), duration, FileUtils.byteCountToDisplaySize(downloadedLayerSize), FileUtils.byteCountToDisplaySize(downloadedLayerSize / duration));
        }
    }

    private long downloadedLayerSize() {
        return this.currentSizes.values().stream().filter(Objects::nonNull).mapToLong(it -> it).sum();
    }

    private long totalLayerSize() {
        return this.totalSizes.values().stream().filter(Objects::nonNull).mapToLong(it -> it).sum();
    }
}

