/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

@Internal
final class NumberTypeSerde
implements SerdeRegistrar<Number>,
NumberSerde<Number> {
    NumberTypeSerde() {
    }

    @Override
    public Argument<Number> getType() {
        return Argument.of(Number.class);
    }

    @Override
    public Number deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Number> type) throws IOException {
        return decoder.decodeNumber();
    }

    @Override
    public Number deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Number> type) throws IOException {
        return decoder.decodeNumberNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Number> type, Number value) throws IOException {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            encoder.encodeInt(integer);
        } else if (value instanceof Long) {
            Long aLong = (Long)value;
            encoder.encodeLong(aLong);
        } else if (value instanceof Double) {
            Double aDouble = (Double)value;
            encoder.encodeDouble(aDouble);
        } else if (value instanceof Float) {
            Float aFloat = (Float)value;
            encoder.encodeFloat(aFloat.floatValue());
        } else if (value instanceof Byte) {
            Byte aByte = (Byte)value;
            encoder.encodeByte(aByte);
        } else if (value instanceof Short) {
            Short aShort = (Short)value;
            encoder.encodeShort(aShort);
        } else if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            encoder.encodeBigDecimal(bigDecimal);
        } else if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            encoder.encodeBigInteger(bigInteger);
        } else {
            throw new SerdeException("Unrecognized Number type: " + value.getClass().getName() + " " + value);
        }
    }

    @Override
    @Nullable
    public Integer getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Number> type) {
        return type.isPrimitive() ? Integer.valueOf(0) : null;
    }
}

