/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

final class LongArraySerde
implements SerdeRegistrar<long[]> {
    LongArraySerde() {
    }

    @Override
    public long[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super long[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        long[] buffer = new long[50];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            if (buffer.length == index) {
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            if (!arrayDecoder.decodeNull()) {
                buffer[index] = arrayDecoder.decodeLong();
            }
            ++index;
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    @Override
    public long[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super long[]> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends long[]> type, long[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (long i : value) {
            arrayEncoder.encodeLong(i);
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, long[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<long[]> getType() {
        return Argument.of(long[].class);
    }
}

