/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

@Internal
@Singleton
@BootstrapContextCompatible
public class NioEventLoopGroupFactory
implements EventLoopGroupFactory {
    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public Class<? extends io.netty.channel.socket.ServerSocketChannel> serverSocketChannelClass() {
        return NioServerSocketChannel.class;
    }

    @Override
    public Class<? extends ServerDomainSocketChannel> domainServerSocketChannelClass() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("UNIX domain sockets are not supported by the NIO implementation right now, please switch to epoll or kqueue");
    }

    @Override
    public NioServerSocketChannel serverSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new NioServerSocketChannel();
    }

    @Override
    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return NioSocketChannel.class;
    }

    @Override
    public SocketChannel clientSocketChannelInstance(EventLoopGroupConfiguration configuration) {
        return new NioSocketChannel();
    }

    private static NioEventLoopGroup withIoRatio(NioEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio);
        }
        return group;
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> NioServerSocketChannel.class;
            case NettyChannelType.CLIENT_SOCKET -> NioSocketChannel.class;
            case NettyChannelType.DOMAIN_SERVER_SOCKET, NettyChannelType.DOMAIN_SOCKET -> throw new UnsupportedOperationException("NIO does not support domain sockets");
            case NettyChannelType.DATAGRAM_SOCKET -> NioDatagramChannel.class;
        };
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(type);
    }

    @Override
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new NioServerSocketChannel();
            case NettyChannelType.CLIENT_SOCKET -> new NioSocketChannel();
            case NettyChannelType.DOMAIN_SERVER_SOCKET, NettyChannelType.DOMAIN_SOCKET -> throw new UnsupportedOperationException("NIO does not support domain sockets");
            case NettyChannelType.DATAGRAM_SOCKET -> new NioDatagramChannel();
        };
    }

    @Override
    @NonNull
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration, Channel parent, int fd) {
        java.nio.channels.Channel inheritedChannel;
        if (fd != 0) {
            throw new IllegalArgumentException("With nio, only channel fd 0 is supported. Either switch to fd 0, or use the epoll transport that supports any fd.");
        }
        try {
            inheritedChannel = System.inheritedChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> {
                if (!(inheritedChannel instanceof ServerSocketChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a ServerSocketChannel. You probably have to pass it as 'accepted-fd' instead of 'fd'.");
                }
                ServerSocketChannel ssc = (ServerSocketChannel)inheritedChannel;
                yield new NioServerSocketChannel(ssc);
            }
            case NettyChannelType.CLIENT_SOCKET -> {
                if (!(inheritedChannel instanceof java.nio.channels.SocketChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a SocketChannel. You probably have to pass it as 'fd' instead of 'accepted-fd'.");
                }
                java.nio.channels.SocketChannel sc = (java.nio.channels.SocketChannel)inheritedChannel;
                yield new NioSocketChannel(parent, sc);
            }
            case NettyChannelType.DOMAIN_SERVER_SOCKET, NettyChannelType.DOMAIN_SOCKET -> throw new UnsupportedOperationException("NIO does not support domain sockets");
            case NettyChannelType.DATAGRAM_SOCKET -> {
                if (!(inheritedChannel instanceof DatagramChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a DatagramChannel.");
                }
                DatagramChannel dc = (DatagramChannel)inheritedChannel;
                yield new NioDatagramChannel(dc);
            }
        };
    }
}

