/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.RawMessageBodyHandler;
import io.micronaut.http.body.RawMessageBodyHandlerRegistry;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@Singleton
@BootstrapContextCompatible
public final class DefaultMessageBodyHandlerRegistry
extends RawMessageBodyHandlerRegistry {
    private final BeanContext beanLocator;
    private final List<CodecConfiguration> codecConfigurations;

    DefaultMessageBodyHandlerRegistry(BeanContext beanLocator, List<CodecConfiguration> codecConfigurations, List<RawMessageBodyHandler<?>> rawHandlers) {
        super(rawHandlers);
        this.beanLocator = beanLocator;
        this.codecConfigurations = codecConfigurations;
    }

    @Override
    protected <T> MessageBodyReader<T> findReaderImpl(Argument<T> type, List<MediaType> mediaTypes) {
        Argument<Object> finalType;
        if (type.isPrimitive()) {
            Class<?> wrapperType = type.getWrapperType();
            finalType = Argument.of(wrapperType, type.getAnnotationMetadata(), new Argument[0]);
        } else {
            finalType = type;
        }
        Collection<BeanDefinition<MessageBodyReader>> beanDefinitions = this.beanLocator.getBeanDefinitions(Argument.of(MessageBodyReader.class, finalType), this.newMediaTypeQualifier(Argument.of(MessageBodyReader.class), mediaTypes, Consumes.class));
        if (beanDefinitions.size() == 1) {
            return this.beanLocator.getBean(beanDefinitions.iterator().next());
        }
        List<BeanDefinition> exactMatch = beanDefinitions.stream().filter(d -> {
            List<Argument<MessageBodyReader>> typeArguments = d.getTypeArguments(MessageBodyReader.class);
            if (typeArguments.isEmpty()) {
                return false;
            }
            return finalType.equalsType(typeArguments.get(0));
        }).toList();
        if (exactMatch.size() == 1) {
            return (MessageBodyReader)this.beanLocator.getBean(exactMatch.iterator().next());
        }
        return beanDefinitions.stream().max(OrderUtil.REVERSE_COMPARATOR).map(this.beanLocator::getBean).orElse(null);
    }

    @NonNull
    private <T, B> MediaTypeQualifier<B> newMediaTypeQualifier(Argument<T> type, List<MediaType> mediaTypes, Class<? extends Annotation> qualifierType) {
        List<MediaType> resolvedMediaTypes = this.resolveMediaTypes(mediaTypes);
        return new MediaTypeQualifier(type, resolvedMediaTypes, qualifierType);
    }

    @NonNull
    private List<MediaType> resolveMediaTypes(List<MediaType> mediaTypes) {
        if (this.codecConfigurations.isEmpty()) {
            return mediaTypes;
        }
        ArrayList<MediaType> resolvedMediaTypes = new ArrayList<MediaType>(mediaTypes.size());
        resolvedMediaTypes.addAll(mediaTypes);
        block0: for (MediaType mediaType : mediaTypes) {
            for (CodecConfiguration codecConfiguration : this.codecConfigurations) {
                List<MediaType> additionalTypes = codecConfiguration.getAdditionalTypes();
                if (!additionalTypes.contains(mediaType)) continue;
                this.beanLocator.findBean(MediaTypeCodec.class, Qualifiers.byName(codecConfiguration.getName())).ifPresent(codec -> resolvedMediaTypes.addAll(codec.getMediaTypes()));
                continue block0;
            }
        }
        return resolvedMediaTypes;
    }

    @Override
    protected <T> MessageBodyWriter<T> findWriterImpl(Argument<T> type, List<MediaType> mediaTypes) {
        Collection<BeanDefinition<MessageBodyWriter>> beanDefinitions = this.beanLocator.getBeanDefinitions(Argument.of(MessageBodyWriter.class), this.newMediaTypeQualifier(Argument.of(MessageBodyWriter.class, type), mediaTypes, Produces.class));
        if (beanDefinitions.size() == 1) {
            return this.beanLocator.getBean(beanDefinitions.iterator().next());
        }
        if (beanDefinitions.isEmpty()) {
            return null;
        }
        List<BeanDefinition> exactMatch = beanDefinitions.stream().filter(d -> {
            List<Argument<MessageBodyWriter>> typeArguments = d.getTypeArguments(MessageBodyWriter.class);
            if (typeArguments.isEmpty()) {
                return false;
            }
            return type.equalsType(typeArguments.get(0));
        }).toList();
        if (exactMatch.size() == 1) {
            return (MessageBodyWriter)this.beanLocator.getBean(exactMatch.iterator().next());
        }
        List<MessageBodyWriter> ordered = beanDefinitions.stream().sorted(OrderUtil.COMPARATOR).map(this.beanLocator::getBean).toList();
        for (MessageBodyWriter writer : ordered) {
            if (!mediaTypes.stream().anyMatch(mediaType -> writer.isWriteable(type, (MediaType)mediaType))) continue;
            return writer;
        }
        return CollectionUtils.isNotEmpty(ordered) ? ordered.get(0) : null;
    }

    private record MediaTypeQualifier<T>(Argument<?> type, List<MediaType> mediaTypes, Class<? extends Annotation> annotationType) implements Qualifier<T>
    {
        @Override
        public <B extends BeanType<T>> Stream<B> reduce(Class<T> beanType, Stream<B> candidates) {
            return candidates.filter(c -> {
                String[] applicableTypes;
                if (this.type.getType() == MessageBodyWriter.class && c instanceof BeanDefinition) {
                    BeanDefinition definition = (BeanDefinition)c;
                    List<Argument<?>> consumedType = definition.getTypeArguments(this.type.getType());
                    Object[] typeParameters = this.type.getTypeParameters();
                    if (ArrayUtils.isEmpty(typeParameters)) {
                        return false;
                    }
                    Object requiredType = typeParameters[0];
                    if (consumedType.isEmpty() || MediaTypeQualifier.isInvalidType(consumedType, requiredType)) {
                        return false;
                    }
                }
                return (applicableTypes = c.getAnnotationMetadata().stringValues(this.annotationType)).length == 0 || Arrays.stream(applicableTypes).anyMatch(mt -> this.mediaTypes.contains(new MediaType((String)mt)));
            });
        }

        private static boolean isInvalidType(List<Argument<?>> consumedType, Argument<?> requiredType) {
            Argument argument = consumedType.get(0);
            return !argument.isTypeVariable() && !argument.isAssignableFrom(requiredType.getType());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaTypeQualifier that = (MediaTypeQualifier)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type.typeHashCode(), this.mediaTypes);
        }
    }
}

