/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.cookie.SameSite;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class HttpTypeConverterRegistrar
implements TypeConverterRegistrar {
    @Override
    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, MediaType.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(MediaType.of(object.toString()));
            }
            catch (IllegalArgumentException e) {
                context.reject(e);
                return Optional.empty();
            }
        });
        ConcurrentHashMap conversions = new ConcurrentHashMap();
        conversionService.addConverter(CharSequence.class, SameSite.class, (object, targetType, context) -> {
            if (object == null) {
                return Optional.empty();
            }
            return conversions.computeIfAbsent(object, charSequence -> {
                try {
                    return Optional.of(SameSite.valueOf(StringUtils.capitalize(object.toString().toLowerCase())));
                }
                catch (IllegalArgumentException e) {
                    return Optional.empty();
                }
            });
        });
    }
}

