/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class StreamUtils {
    public static <T, A, D> Collector<T, ?, D> maxAll(Comparator<? super T> comparator, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BinaryOperator downstreamCombiner = downstream.combiner();
        class Container {
            A acc;
            T obj;
            boolean hasAny;

            Container(A acc) {
                this.acc = acc;
            }
        }
        Supplier<Container> supplier = () -> new Container(downstreamSupplier.get());
        BiConsumer<Container, Object> accumulator = (acc, t2) -> {
            if (!acc.hasAny) {
                downstreamAccumulator.accept(acc.acc, (Object)t2);
                acc.obj = t2;
                acc.hasAny = true;
            } else {
                int cmp = comparator.compare(t2, acc.obj);
                if (cmp > 0) {
                    acc.acc = downstreamSupplier.get();
                    acc.obj = t2;
                }
                if (cmp >= 0) {
                    downstreamAccumulator.accept(acc.acc, (Object)t2);
                }
            }
        };
        BinaryOperator combiner = (acc1, acc2) -> {
            if (!acc2.hasAny) {
                return acc1;
            }
            if (!acc1.hasAny) {
                return acc2;
            }
            int cmp = comparator.compare((Object)acc1.obj, (Object)acc2.obj);
            if (cmp > 0) {
                return acc1;
            }
            if (cmp < 0) {
                return acc2;
            }
            acc1.acc = downstreamCombiner.apply(acc1.acc, acc2.acc);
            return acc1;
        };
        Function<Container, Object> finisher = acc -> downstream.finisher().apply(acc.acc);
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T, A, D> Collector<T, ?, D> minAll(Comparator<? super T> comparator, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BinaryOperator downstreamCombiner = downstream.combiner();
        class Container {
            A acc;
            T obj;
            boolean hasAny;

            Container(A acc) {
                this.acc = acc;
            }
        }
        Supplier<Container> supplier = () -> new Container(downstreamSupplier.get());
        BiConsumer<Container, Object> accumulator = (acc, t2) -> {
            if (!acc.hasAny) {
                downstreamAccumulator.accept(acc.acc, (Object)t2);
                acc.obj = t2;
                acc.hasAny = true;
            } else {
                int cmp = comparator.compare(t2, acc.obj);
                if (cmp < 0) {
                    acc.acc = downstreamSupplier.get();
                    acc.obj = t2;
                }
                if (cmp <= 0) {
                    downstreamAccumulator.accept(acc.acc, (Object)t2);
                }
            }
        };
        BinaryOperator combiner = (acc1, acc2) -> {
            if (!acc2.hasAny) {
                return acc1;
            }
            if (!acc1.hasAny) {
                return acc2;
            }
            int cmp = comparator.compare((Object)acc1.obj, (Object)acc2.obj);
            if (cmp < 0) {
                return acc1;
            }
            if (cmp > 0) {
                return acc2;
            }
            acc1.acc = downstreamCombiner.apply(acc1.acc, acc2.acc);
            return acc1;
        };
        Function<Container, Object> finisher = acc -> downstream.finisher().apply(acc.acc);
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T, A extends Collection<T>> Collector<T, A, Collection<T>> toImmutableCollection(Supplier<A> collectionFactory) {
        return Collector.of(collectionFactory, Collection::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableCollection, new Collector.Characteristics[0]);
    }
}

