/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.ApplicationContextConfigurer;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.CommandLinePropertySource;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.cli.CommandLine;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DefaultApplicationContextBuilder
implements ApplicationContextBuilder,
ApplicationContextConfiguration {
    private final List<Object> singletons = new ArrayList<Object>();
    private final List<String> environments = new ArrayList<String>();
    private final List<String> defaultEnvironments = new ArrayList<String>();
    private final List<String> packages = new ArrayList<String>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final List<PropertySource> propertySources = new ArrayList<PropertySource>();
    private final Collection<String> configurationIncludes = new HashSet<String>();
    private final Collection<String> configurationExcludes = new HashSet<String>();
    private Boolean deduceEnvironments = null;
    private boolean deduceCloudEnvironment = false;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private boolean envPropertySource = true;
    private final List<String> envVarIncludes = new ArrayList<String>();
    private final List<String> envVarExcludes = new ArrayList<String>();
    private String[] args = StringUtils.EMPTY_STRING_ARRAY;
    private final Set<Class<? extends Annotation>> eagerInitAnnotated = new HashSet<Class<? extends Annotation>>(3);
    private String[] overrideConfigLocations;
    private boolean banner = true;
    private ClassPathResourceLoader classPathResourceLoader;
    private boolean allowEmptyProviders = false;
    private Boolean bootstrapEnvironment = null;
    private boolean enableDefaultPropertySources = true;

    protected DefaultApplicationContextBuilder() {
        DefaultApplicationContextBuilder.loadApplicationContextCustomizer(this.resolveClassLoader()).configure(this);
    }

    DefaultApplicationContextBuilder(ClassLoader classLoader) {
        DefaultApplicationContextBuilder.loadApplicationContextCustomizer(classLoader).configure(this);
        this.classLoader = classLoader;
    }

    private ClassLoader resolveClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return DefaultApplicationContextBuilder.class.getClassLoader();
    }

    @Override
    public boolean isAllowEmptyProviders() {
        return this.allowEmptyProviders;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder enableDefaultPropertySources(boolean areEnabled) {
        this.enableDefaultPropertySources = areEnabled;
        return this;
    }

    @Override
    public boolean isEnableDefaultPropertySources() {
        return this.enableDefaultPropertySources;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder eagerInitAnnotated(Class<? extends Annotation> ... annotations) {
        if (annotations != null) {
            this.eagerInitAnnotated.addAll(Arrays.asList(annotations));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder overrideConfigLocations(String ... configLocations) {
        this.overrideConfigLocations = configLocations;
        return this;
    }

    @Override
    @Nullable
    public List<String> getOverrideConfigLocations() {
        return this.overrideConfigLocations == null ? null : Arrays.asList(this.overrideConfigLocations);
    }

    @Override
    public boolean isBannerEnabled() {
        return this.banner;
    }

    @Override
    @Nullable
    public Boolean isBootstrapEnvironmentEnabled() {
        return this.bootstrapEnvironment;
    }

    @Override
    public Set<Class<? extends Annotation>> getEagerInitAnnotated() {
        return Collections.unmodifiableSet(this.eagerInitAnnotated);
    }

    @Override
    @NonNull
    public ApplicationContextBuilder singletons(Object ... beans) {
        if (beans != null) {
            this.singletons.addAll(Arrays.asList(beans));
        }
        return this;
    }

    @Override
    @NonNull
    public ClassPathResourceLoader getResourceLoader() {
        if (this.classPathResourceLoader == null) {
            this.classPathResourceLoader = this.classLoader != null ? ClassPathResourceLoader.defaultLoader(this.classLoader) : ClassPathResourceLoader.defaultLoader(this.getClass().getClassLoader());
        }
        return this.classPathResourceLoader;
    }

    @Override
    @NonNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder deduceEnvironment(@Nullable Boolean deduceEnvironments) {
        this.deduceEnvironments = deduceEnvironments;
        return this;
    }

    @Override
    public ApplicationContextBuilder deduceCloudEnvironment(boolean deduceEnvironment) {
        this.deduceCloudEnvironment = deduceEnvironment;
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environments(String ... environments) {
        if (environments != null) {
            this.environments.addAll(Arrays.asList(environments));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder defaultEnvironments(String ... environments) {
        if (environments != null) {
            this.defaultEnvironments.addAll(Arrays.asList(environments));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder packages(String ... packages) {
        if (packages != null) {
            this.packages.addAll(Arrays.asList(packages));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder properties(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder propertySources(PropertySource ... propertySources) {
        if (propertySources != null) {
            this.propertySources.addAll(Arrays.asList(propertySources));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environmentPropertySource(boolean environmentPropertySource) {
        this.envPropertySource = environmentPropertySource;
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environmentVariableIncludes(String ... environmentVariables) {
        if (environmentVariables != null) {
            this.envVarIncludes.addAll(Arrays.asList(environmentVariables));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder environmentVariableExcludes(String ... environmentVariables) {
        if (environmentVariables != null) {
            this.envVarExcludes.addAll(Arrays.asList(environmentVariables));
        }
        return this;
    }

    @Override
    public Optional<Boolean> getDeduceEnvironments() {
        return Optional.ofNullable(this.deduceEnvironments);
    }

    @Override
    public boolean isDeduceCloudEnvironment() {
        boolean basicDeduce = this.getDeduceEnvironments().orElse(true);
        return basicDeduce && this.deduceCloudEnvironment;
    }

    @Override
    @NonNull
    public List<String> getEnvironments() {
        return this.environments;
    }

    @Override
    @NonNull
    public List<String> getDefaultEnvironments() {
        return this.defaultEnvironments;
    }

    @Override
    public boolean isEnvironmentPropertySource() {
        return this.envPropertySource;
    }

    @Override
    @Nullable
    public List<String> getEnvironmentVariableIncludes() {
        return this.envVarIncludes.isEmpty() ? null : this.envVarIncludes;
    }

    @Override
    @Nullable
    public List<String> getEnvironmentVariableExcludes() {
        return this.envVarExcludes.isEmpty() ? null : this.envVarExcludes;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder mainClass(Class<?> mainClass) {
        if (mainClass != null) {
            String name;
            if (this.classLoader == null) {
                this.classLoader = mainClass.getClassLoader();
            }
            if (StringUtils.isNotEmpty(name = mainClass.getPackage().getName())) {
                this.packages(name);
            }
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder classLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder args(String ... args) {
        if (args != null) {
            this.args = args;
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder bootstrapEnvironment(boolean bootstrapEnv) {
        this.bootstrapEnvironment = bootstrapEnv;
        return this;
    }

    @Override
    @NonNull
    public ApplicationContext build() {
        ApplicationContext applicationContext = this.newApplicationContext();
        Environment environment = applicationContext.getEnvironment();
        if (!this.packages.isEmpty()) {
            for (String aPackage : this.packages) {
                environment.addPackage(aPackage);
            }
        }
        if (!this.properties.isEmpty()) {
            PropertySource contextProperties = PropertySource.of("context", this.properties, 0);
            environment.addPropertySource(contextProperties);
        }
        if (this.args.length > 0) {
            CommandLine commandLine = CommandLine.parse(this.args);
            environment.addPropertySource(new CommandLinePropertySource(commandLine));
        }
        if (!this.propertySources.isEmpty()) {
            for (PropertySource propertySource : this.propertySources) {
                environment.addPropertySource(propertySource);
            }
        }
        if (!this.singletons.isEmpty()) {
            for (Object singleton : this.singletons) {
                applicationContext.registerSingleton(singleton);
            }
        }
        if (!this.configurationIncludes.isEmpty()) {
            environment.addConfigurationIncludes(this.configurationIncludes.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        if (!this.configurationExcludes.isEmpty()) {
            environment.addConfigurationExcludes(this.configurationExcludes.toArray(StringUtils.EMPTY_STRING_ARRAY));
        }
        return applicationContext;
    }

    @NonNull
    protected ApplicationContext newApplicationContext() {
        return new DefaultApplicationContext(this);
    }

    @Override
    @NonNull
    public ApplicationContextBuilder include(String ... configurations) {
        if (configurations != null) {
            this.configurationIncludes.addAll(Arrays.asList(configurations));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder exclude(String ... configurations) {
        if (configurations != null) {
            this.configurationExcludes.addAll(Arrays.asList(configurations));
        }
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder banner(boolean isEnabled) {
        this.banner = isEnabled;
        return this;
    }

    @Override
    @NonNull
    public ApplicationContextBuilder allowEmptyProviders(boolean shouldAllow) {
        this.allowEmptyProviders = shouldAllow;
        return this;
    }

    @NonNull
    private static ApplicationContextConfigurer loadApplicationContextCustomizer(@Nullable ClassLoader classLoader) {
        SoftServiceLoader<ApplicationContextConfigurer> loader = SoftServiceLoader.load(ApplicationContextConfigurer.class, classLoader);
        final ArrayList configurers = new ArrayList(10);
        loader.collectAll(configurers);
        if (configurers.isEmpty()) {
            return ApplicationContextConfigurer.NO_OP;
        }
        if (configurers.size() == 1) {
            return (ApplicationContextConfigurer)configurers.get(0);
        }
        OrderUtil.sortOrdered(configurers);
        return new ApplicationContextConfigurer(){

            @Override
            public void configure(ApplicationContextBuilder builder) {
                for (ApplicationContextConfigurer customizer : configurers) {
                    customizer.configure(builder);
                }
            }
        };
    }
}

