/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.core;

import java.util.Map;

public final class Scope {
    public static final Scope ROOT = new Scope(null, null);
    public static final String PROPERTY_KEY = "micronaut.test.resources.scope";
    private final String id;
    private final Scope parent;

    private Scope(Scope parent, String id) {
        this.id = id;
        this.parent = parent;
    }

    public static Scope from(Map<String, Object> properties) {
        Object scopeId = properties.getOrDefault(PROPERTY_KEY, null);
        if (scopeId == null) {
            return ROOT;
        }
        return Scope.of(String.valueOf(scopeId));
    }

    public Scope child(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Child name cannot be null");
        }
        return new Scope(this, id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        if (this.id != null ? !this.id.equals(scope.id) : scope.id != null) {
            return false;
        }
        return this.parent != null ? this.parent.equals(scope.parent) : scope.parent == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.id == null || this.parent == null) {
            return "";
        }
        if (ROOT.equals(this.parent)) {
            return this.id;
        }
        return this.parent + "." + this.id;
    }

    public boolean includes(Scope scope) {
        Scope cur = scope;
        while (cur != null) {
            if (cur.equals(this)) {
                return true;
            }
            cur = cur.parent;
        }
        return false;
    }

    public static Scope of(String id) {
        if (id == null || id.isEmpty()) {
            return ROOT;
        }
        Scope scope = ROOT;
        for (String elem : id.split("[.]")) {
            scope = scope.child(elem);
        }
        return scope;
    }
}

