/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.client;

import io.micronaut.context.ApplicationContext;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.testresources.client.ConfigFinder;
import io.micronaut.testresources.client.DefaultTestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientPropertySourceLoader;
import io.micronaut.testresources.client.TestResourcesException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Properties;

public final class TestResourcesClientFactory {
    private static final String DEFAULT_TIMEOUT_SECONDS = "60";

    private TestResourcesClientFactory() {
    }

    static TestResourcesClient configuredAt(URL configFile) {
        Properties props = new Properties();
        try (InputStream input = configFile.openStream();){
            props.load(input);
        }
        catch (IOException e) {
            throw new TestResourcesException(e);
        }
        try {
            String serverUri = props.getProperty("server.uri");
            String accessToken = props.getProperty("server.access.token");
            int clientReadTimeout = Integer.parseInt(props.getProperty("server.client.read.timeout", DEFAULT_TIMEOUT_SECONDS));
            DefaultHttpClientConfiguration config = new DefaultHttpClientConfiguration();
            config.setReadTimeout(Duration.of(clientReadTimeout, ChronoUnit.SECONDS));
            HttpClient client = HttpClient.create((URL)new URL(serverUri), (HttpClientConfiguration)config);
            return new DefaultTestResourcesClient(client, accessToken);
        }
        catch (MalformedURLException e) {
            throw new TestResourcesException(e);
        }
    }

    static Optional<TestResourcesClient> fromSystemProperties() {
        String serverUri = System.getProperty(ConfigFinder.systemPropertyNameOf("server.uri"));
        if (serverUri != null) {
            HttpClient client;
            String accessToken = System.getProperty(ConfigFinder.systemPropertyNameOf("server.access.token"));
            String clientTimeoutString = System.getProperty(ConfigFinder.systemPropertyNameOf("server.client.read.timeout"), DEFAULT_TIMEOUT_SECONDS);
            int clientReadTimeout = Integer.parseInt(clientTimeoutString);
            DefaultHttpClientConfiguration config = new DefaultHttpClientConfiguration();
            config.setReadTimeout(Duration.of(clientReadTimeout, ChronoUnit.SECONDS));
            try {
                client = HttpClient.create((URL)new URL(serverUri), (HttpClientConfiguration)config);
            }
            catch (MalformedURLException e) {
                return Optional.empty();
            }
            return Optional.of(new DefaultTestResourcesClient(client, accessToken));
        }
        return Optional.empty();
    }

    public static TestResourcesClient extractFrom(ApplicationContext context) {
        return context.getEnvironment().getPropertySourceLoaders().stream().filter(TestResourcesClientPropertySourceLoader.class::isInstance).map(TestResourcesClientPropertySourceLoader.class::cast).map(TestResourcesClientPropertySourceLoader::getClient).findFirst().orElse(Optional.empty()).orElse(null);
    }
}

