/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.support.sql;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import io.micronaut.test.support.sql.DataSourceSqlHandler;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
@Requires(classes={DelegatingDataSource.class, DataSource.class})
@Replaces(value=DataSourceSqlHandler.class)
public class DelegatingDataSourceSqlHandler
extends DataSourceSqlHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingDataSourceSqlHandler.class);

    @Override
    public void handle(@NonNull DataSource dataSource, @NonNull String sql) {
        if (dataSource instanceof DelegatingDataSource) {
            DelegatingDataSource delegatingDataSource = (DelegatingDataSource)dataSource;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Unwrapping DelegatingDataSource: {}", (Object)delegatingDataSource);
            }
            dataSource = delegatingDataSource.getTargetDataSource();
        }
        super.handle(dataSource, sql);
    }
}

