/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.annotation;

import io.micronaut.core.reflect.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <A extends Annotation> List<A> findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("annotationType must not be null");
        }
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        if (repeatable == null) {
            throw new IllegalArgumentException(annotationType.getName() + " must be @Repeatable");
        }
        Class<? extends Annotation> containerType = repeatable.value();
        boolean inherited = containerType.isAnnotationPresent(Inherited.class);
        if (element == null) {
            return Collections.emptyList();
        }
        LinkedHashSet found = new LinkedHashSet(16);
        AnnotationUtils.findRepeatableAnnotations(element, annotationType, containerType, inherited, found, new HashSet<Annotation>(16));
        return Collections.unmodifiableList(new ArrayList(found));
    }

    private static <A extends Annotation> void findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, Class<? extends Annotation> containerType, boolean inherited, Set<A> found, Set<Annotation> visited) {
        if (element instanceof Class) {
            Class superclass;
            Class clazz = (Class)element;
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
                AnnotationUtils.findRepeatableAnnotations(superclass, annotationType, containerType, inherited, found, visited);
            }
            for (Class<?> ifc : clazz.getInterfaces()) {
                if (ifc == Annotation.class) continue;
                AnnotationUtils.findRepeatableAnnotations(ifc, annotationType, containerType, inherited, found, visited);
            }
        }
        AnnotationUtils.findRepeatableAnnotations(element.getDeclaredAnnotations(), annotationType, containerType, inherited, found, visited);
        AnnotationUtils.findRepeatableAnnotations(element.getAnnotations(), annotationType, containerType, inherited, found, visited);
    }

    private static <A extends Annotation> void findRepeatableAnnotations(Annotation[] candidates, Class<A> annotationType, Class<? extends Annotation> containerType, boolean inherited, Set<A> found, Set<Annotation> visited) {
        for (Annotation candidate : candidates) {
            Class<? extends Annotation> candidateAnnotationType = candidate.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotationType) || !visited.add(candidate)) continue;
            if (candidateAnnotationType.equals(annotationType)) {
                found.add(annotationType.cast(candidate));
                continue;
            }
            if (candidateAnnotationType.equals(containerType)) {
                Method method = (Method)ReflectionUtils.getMethod(containerType, (String)"value", (Class[])new Class[0]).orElseThrow(() -> new IllegalStateException(String.format("Container annotation type '%s' must declare a 'value' attribute of type %s[].", containerType, annotationType)));
                Annotation[] containedAnnotations = (Annotation[])ReflectionUtils.invokeMethod((Object)candidate, (Method)method, (Object[])new Object[0]);
                found.addAll(Arrays.asList(containedAnnotations));
                continue;
            }
            AnnotationUtils.findRepeatableAnnotations(candidateAnnotationType, annotationType, containerType, inherited, found, visited);
        }
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }
}

