/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class NewArrayInitializedExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.NewArrayInitialized newArray;

    public NewArrayInitializedExpressionWriter(ExpressionDef.NewArrayInitialized newArray) {
        this.newArray = newArray;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        List expressions = this.newArray.expressions();
        generatorAdapter.push(expressions.size());
        TypeDef.Array arrayType = this.newArray.type();
        TypeDef componentType = arrayType.componentType();
        if (arrayType.dimensions() > 1) {
            componentType = componentType.array(arrayType.dimensions() - 1);
        }
        Type type = TypeUtils.getType(componentType, context.objectDef());
        generatorAdapter.newArray(type);
        if (!expressions.isEmpty()) {
            int index = 0;
            for (ExpressionDef expression : expressions) {
                generatorAdapter.dup();
                generatorAdapter.push(index++);
                ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, expression, componentType);
                generatorAdapter.arrayStore(type);
            }
        }
    }
}

