/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.config.InterceptUrlPatternModifier;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.rules.InterceptUrlMapRule;
import io.micronaut.security.token.RolesFinder;
import jakarta.inject.Singleton;
import java.util.List;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(beans={RolesFinder.class, SecurityConfiguration.class, InterceptUrlPatternModifier.class})})
@Singleton
public class ConfigurationInterceptUrlMapRule
extends InterceptUrlMapRule {
    public static final Integer ORDER = -100;
    private final List<InterceptUrlMapPattern> patternList;

    public ConfigurationInterceptUrlMapRule(RolesFinder rolesFinder, SecurityConfiguration securityConfiguration, InterceptUrlPatternModifier interceptUrlPatternModifier) {
        super(rolesFinder);
        this.patternList = securityConfiguration.getInterceptUrlMap().stream().map(interceptUrlPatternModifier::modify).toList();
    }

    @Override
    protected List<InterceptUrlMapPattern> getPatternList() {
        return this.patternList;
    }

    public int getOrder() {
        return ORDER;
    }
}

