/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.serde.annotation.Serdeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Serdeable
public class ClientAuthentication
implements Authentication {
    private final String name;
    private final Map<String, Object> attributes;

    @JsonCreator
    public ClientAuthentication(@JsonProperty(value="name") String name, @JsonProperty(value="attributes") Map<String, Object> attributes) {
        this.name = name;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    @Override
    @NonNull
    @JsonIgnore
    public Collection<String> getRoles() {
        if (this.attributes != null) {
            Object roleAttribute;
            Object rolesKey = this.attributes.get("rolesKey");
            if (rolesKey == null) {
                rolesKey = "roles";
            }
            if ((roleAttribute = this.attributes.get(rolesKey.toString())) != null) {
                ArrayList<String> roles = new ArrayList<String>();
                if (roleAttribute instanceof Iterable) {
                    for (Object o : (Iterable)roleAttribute) {
                        roles.add(o.toString());
                    }
                } else {
                    roles.add(roleAttribute.toString());
                }
                return roles;
            }
        }
        return Collections.emptyList();
    }
}

