/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.Authenticator;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import io.micronaut.security.event.LoginFailedEvent;
import io.micronaut.security.event.LoginSuccessfulEvent;
import io.micronaut.security.handlers.LoginHandler;
import jakarta.validation.Valid;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(property="micronaut.security.endpoints.login.enabled", notEquals="false", defaultValue="true"), @Requires(classes={Controller.class}), @Requires(beans={LoginHandler.class, Authenticator.class})})
@Controller(value="${micronaut.security.endpoints.login.path:/login}")
@Secured(value={"isAnonymous()"})
public class LoginController<B> {
    private static final Logger LOG = LoggerFactory.getLogger(LoginController.class);
    protected final Authenticator<HttpRequest<B>, String, String> authenticator;
    protected final LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler;
    protected final ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher;
    protected final ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher;

    public LoginController(Authenticator<HttpRequest<B>, String, String> authenticator, LoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler, ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher, ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher) {
        this.authenticator = authenticator;
        this.loginHandler = loginHandler;
        this.loginSuccessfulEventPublisher = loginSuccessfulEventPublisher;
        this.loginFailedEventPublisher = loginFailedEventPublisher;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    @SingleResult
    public Publisher<MutableHttpResponse<?>> login(@Valid @Body UsernamePasswordCredentials usernamePasswordCredentials, HttpRequest<B> request) {
        return Flux.from(this.authenticator.authenticate(request, usernamePasswordCredentials)).map(authenticationResponse -> {
            if (authenticationResponse.isAuthenticated() && authenticationResponse.getAuthentication().isPresent()) {
                Authentication authentication = authenticationResponse.getAuthentication().get();
                this.loginSuccessfulEventPublisher.publishEvent((Object)new LoginSuccessfulEvent(authentication));
                return this.loginHandler.loginSuccess(authentication, request);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("login failed for username: {}", (Object)usernamePasswordCredentials.getUsername());
            }
            this.loginFailedEventPublisher.publishEvent((Object)new LoginFailedEvent(authenticationResponse, usernamePasswordCredentials));
            return this.loginHandler.loginFailed((AuthenticationResponse)authenticationResponse, request);
        }).switchIfEmpty((Publisher)Mono.defer(() -> Mono.just((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED))));
    }
}

