/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.utils;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.filters.SecurityFilter;
import java.security.Principal;
import java.util.Optional;

@Internal
public final class SecurityBindingResultUtils {
    private SecurityBindingResultUtils() {
    }

    @NonNull
    public static <A extends Principal> ArgumentBinder.BindingResult<A> authentication(@NonNull HttpRequest<?> request, @NonNull Class<A> authenticationClass) {
        if (!request.getAttributes().contains(SecurityFilter.KEY)) {
            return ArgumentBinder.BindingResult.UNSATISFIED;
        }
        Optional existing = request.getUserPrincipal(authenticationClass);
        return existing.isPresent() ? () -> existing : ArgumentBinder.BindingResult.EMPTY;
    }
}

