/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.security.authentication.AuthorizationException;
import io.micronaut.security.authentication.WwwAuthenticateChallengeProvider;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.errors.PriorToLoginPersistence;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(classes={ExceptionHandler.class})
@Singleton
public class DefaultAuthorizationExceptionHandler
implements ExceptionHandler<AuthorizationException, MutableHttpResponse<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationExceptionHandler.class);
    private static final String COMMA_SPACE = ", ";
    private final ErrorResponseProcessor<?> errorResponseProcessor;
    private final RedirectConfiguration redirectConfiguration;
    private final List<WwwAuthenticateChallengeProvider<HttpRequest<?>>> wwwAuthenticateChallengeProviders;
    private final RedirectService redirectService;
    private final PriorToLoginPersistence priorToLoginPersistence;

    @Inject
    public DefaultAuthorizationExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor, RedirectConfiguration redirectConfiguration, RedirectService redirectService, List<WwwAuthenticateChallengeProvider<HttpRequest<?>>> wwwAuthenticateChallengeProviders, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        this.errorResponseProcessor = errorResponseProcessor;
        this.redirectConfiguration = redirectConfiguration;
        this.redirectService = redirectService;
        this.priorToLoginPersistence = priorToLoginPersistence;
        this.wwwAuthenticateChallengeProviders = wwwAuthenticateChallengeProviders;
    }

    @Deprecated(forRemoval=true, since="4.14.0")
    public DefaultAuthorizationExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor, RedirectConfiguration redirectConfiguration, RedirectService redirectService, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        this(errorResponseProcessor, redirectConfiguration, redirectService, Collections.emptyList(), priorToLoginPersistence);
    }

    public MutableHttpResponse<?> handle(HttpRequest request, AuthorizationException exception) {
        if (this.shouldRedirect(request, exception)) {
            try {
                URI location = new URI(this.getRedirectUri(request, exception));
                if (!request.getUri().equals(location)) {
                    MutableHttpResponse<?> response = this.httpResponseWithStatus(location);
                    if (this.priorToLoginPersistence != null && !exception.isForbidden()) {
                        this.priorToLoginPersistence.onUnauthorized(request, response);
                    }
                    return response;
                }
                return this.httpResponseWithStatus(request, exception);
            }
            catch (URISyntaxException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Rejection redirect URL is invalid", (Throwable)e);
                }
                return HttpResponse.serverError();
            }
        }
        return this.httpResponseWithStatus(request, exception);
    }

    protected MutableHttpResponse<?> httpResponseWithStatus(HttpRequest<?> request, AuthorizationException exception) {
        HttpStatus status = exception.isForbidden() ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED;
        MutableHttpResponse response = HttpResponse.status((HttpStatus)status);
        if (CollectionUtils.isNotEmpty(this.wwwAuthenticateChallengeProviders)) {
            response.header((CharSequence)"WWW-Authenticate", (CharSequence)String.join((CharSequence)COMMA_SPACE, this.wwwAuthenticateChallengeProviders.stream().map(provider -> provider.getWwwAuthenticateChallenge(request)).toList()));
        }
        return this.errorResponseProcessor.processResponse(ErrorContext.builder(request).cause((Throwable)exception).errorMessage(status.getReason()).build(), response);
    }

    protected boolean shouldRedirect(HttpRequest<?> request, AuthorizationException exception) {
        if (this.redirectConfiguration != null && this.redirectConfiguration.isEnabled()) {
            return (exception.isForbidden() && this.redirectConfiguration.getForbidden().isEnabled() || !exception.isForbidden() && this.redirectConfiguration.getUnauthorized().isEnabled()) && request.getHeaders().accept().stream().anyMatch(mediaType -> mediaType.equals((Object)MediaType.TEXT_HTML_TYPE));
        }
        return false;
    }

    protected String getRedirectUri(HttpRequest<?> request, AuthorizationException exception) {
        String uri;
        String string = uri = exception.isForbidden() ? this.redirectService.forbiddenUrl() : this.redirectService.unauthorizedUrl();
        if (LOG.isDebugEnabled()) {
            LOG.debug("redirect uri: {}", (Object)uri);
        }
        return uri;
    }

    protected MutableHttpResponse<?> httpResponseWithStatus(URI location) {
        return HttpResponse.status((HttpStatus)HttpStatus.SEE_OTHER).headers(headers -> headers.location(location));
    }
}

