/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;

@Serdeable
public class UsernamePasswordCredentials
implements Serializable,
AuthenticationRequest<String, String> {
    @NotBlank
    private String username;
    @NotBlank
    private String password;

    @Creator
    public UsernamePasswordCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public UsernamePasswordCredentials() {
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @Override
    @Nullable
    public String getIdentity() {
        return this.getUsername();
    }

    @Override
    @Nullable
    public String getSecret() {
        return this.getPassword();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        return this.password != null ? this.password.equals(that.password) : that.password == null;
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }
}

