/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.endpoints.ControllerConfigurationProperties;
import io.micronaut.security.endpoints.OauthControllerConfiguration;

@Requires(property="micronaut.security.endpoints.oauth.enabled", notEquals="false", defaultValue="true")
@ConfigurationProperties(value="micronaut.security.endpoints.oauth")
public class OauthControllerConfigurationProperties
extends ControllerConfigurationProperties
implements OauthControllerConfiguration {
    public static final String PREFIX = "micronaut.security.endpoints.oauth";
    @Deprecated(forRemoval=true, since="4.11.0")
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_PATH = "/oauth/access_token";
    public static final boolean DEFAULT_GETALLOWED = true;
    private boolean getAllowed = true;

    public OauthControllerConfigurationProperties() {
        super(DEFAULT_PATH);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(true);
    }

    @Override
    public void setPath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            super.setPath(path);
        }
    }

    @Override
    public boolean isGetAllowed() {
        return this.getAllowed;
    }

    public void setGetAllowed(boolean getAllowed) {
        this.getAllowed = getAllowed;
    }
}

