/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class ClaimsUtils {
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    private static final Map<ClaimPair, Boolean> CACHE = new ConcurrentHashMap<ClaimPair, Boolean>();

    private ClaimsUtils() {
    }

    public static boolean endsWithIgnoringProtocolAndTrailingSlash(@NonNull String expectedClaim, @NonNull String claim) {
        ClaimPair pair = new ClaimPair(expectedClaim, claim);
        return CACHE.computeIfAbsent(pair, claimPair -> ClaimsUtils.removeLeadingProtocolAndTrailingSlash(claimPair.expectedClaim()).endsWith(ClaimsUtils.removeLeadingProtocolAndTrailingSlash(claimPair.claim())));
    }

    @NonNull
    static String removeLeadingProtocolAndTrailingSlash(@NonNull String claim) {
        return ClaimsUtils.removeTrailingSlash(ClaimsUtils.removeProtocol(claim));
    }

    @NonNull
    private static String removeTrailingSlash(@NonNull String iss) {
        return iss.endsWith(SLASH) ? iss.substring(0, iss.length() - SLASH.length()) : iss;
    }

    @NonNull
    private static String removeProtocol(@NonNull String iss) {
        return iss.replace(HTTP, EMPTY).replace(HTTPS, EMPTY);
    }

    record ClaimPair(String expectedClaim, String claim) {
    }
}

