/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationProviderAdapter;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.provider.ExecutorAuthenticationProvider;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProvider;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProviderAdapter;
import io.micronaut.security.config.AuthenticationStrategy;
import io.micronaut.security.config.SecurityConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
public class Authenticator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    @Deprecated(forRemoval=true, since="4.5.0")
    protected final Collection<AuthenticationProvider<T>> authenticationProviders;
    private final List<ReactiveAuthenticationProvider<T, ?, ?>> reactiveAuthenticationProviders;
    private final BeanContext beanContext;
    private final List<io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?>> imperativeAuthenticationProviders;
    private final SecurityConfiguration securityConfiguration;
    private final Map<String, Scheduler> executeNameToScheduler = new ConcurrentHashMap<String, Scheduler>();

    @Inject
    public Authenticator(BeanContext beanContext, List<ReactiveAuthenticationProvider<T, ?, ?>> reactiveAuthenticationProviders, List<io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?>> authenticationProviders, List<AuthenticationProvider<T>> deprecatedAuthenticationProviders, SecurityConfiguration securityConfiguration) {
        this.beanContext = beanContext;
        this.reactiveAuthenticationProviders = reactiveAuthenticationProviders;
        for (AuthenticationProvider<T> authenticationProvider : deprecatedAuthenticationProviders) {
            reactiveAuthenticationProviders.add(new ReactiveAuthenticationProviderAdapter(authenticationProvider));
        }
        this.securityConfiguration = securityConfiguration;
        this.imperativeAuthenticationProviders = authenticationProviders;
        this.authenticationProviders = Collections.emptyList();
    }

    public Authenticator(BeanContext beanContext, List<ReactiveAuthenticationProvider<T, ?, ?>> reactiveAuthenticationProviders, List<io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?>> authenticationProviders, SecurityConfiguration securityConfiguration) {
        this.beanContext = beanContext;
        this.reactiveAuthenticationProviders = reactiveAuthenticationProviders;
        this.securityConfiguration = securityConfiguration;
        this.imperativeAuthenticationProviders = authenticationProviders;
        this.authenticationProviders = Collections.emptyList();
    }

    @Deprecated(forRemoval=true, since="4.5.0")
    public Authenticator(Collection<AuthenticationProvider<T>> deprecatedAuthenticationProviders, SecurityConfiguration securityConfiguration) {
        this.beanContext = null;
        this.authenticationProviders = deprecatedAuthenticationProviders;
        this.reactiveAuthenticationProviders = new ArrayList();
        for (AuthenticationProvider<T> authenticationProvider : deprecatedAuthenticationProviders) {
            this.reactiveAuthenticationProviders.add(new ReactiveAuthenticationProviderAdapter(authenticationProvider));
        }
        this.securityConfiguration = securityConfiguration;
        this.imperativeAuthenticationProviders = Collections.emptyList();
    }

    public Publisher<AuthenticationResponse> authenticate(T requestContext, AuthenticationRequest<?, ?> authenticationRequest) {
        if (CollectionUtils.isEmpty(this.reactiveAuthenticationProviders) && CollectionUtils.isEmpty(this.imperativeAuthenticationProviders)) {
            return Mono.empty();
        }
        if (LOG.isDebugEnabled() && this.imperativeAuthenticationProviders != null) {
            LOG.debug(this.imperativeAuthenticationProviders.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining()));
        }
        if (LOG.isDebugEnabled() && this.reactiveAuthenticationProviders != null) {
            LOG.debug(this.reactiveAuthenticationProviders.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining()));
        }
        if (CollectionUtils.isEmpty(this.reactiveAuthenticationProviders) && this.imperativeAuthenticationProviders != null && !this.anyImperativeAuthenticationProviderIsBlocking()) {
            return Mono.just((Object)this.authenticate(requestContext, authenticationRequest, this.imperativeAuthenticationProviders, this.securityConfiguration));
        }
        return this.authenticate(requestContext, authenticationRequest, this.everyProviderSorted());
    }

    private boolean anyImperativeAuthenticationProviderIsBlocking() {
        return this.imperativeAuthenticationProviders.stream().anyMatch(this::isImperativeAuthenticationProviderIsBlocking);
    }

    protected boolean isImperativeAuthenticationProviderIsBlocking(io.micronaut.security.authentication.provider.AuthenticationProvider<?, ?, ?> authenticationProvider) {
        ExecutorAuthenticationProvider ap;
        return authenticationProvider instanceof ExecutorAuthenticationProvider && ((ap = (ExecutorAuthenticationProvider)authenticationProvider).getExecutorName().equals("blocking") || ap.getExecutorName().equals("io"));
    }

    @NonNull
    private AuthenticationResponse authenticate(@NonNull T requestContext, @NonNull AuthenticationRequest<?, ?> authenticationRequest, @NonNull List<io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?>> authenticationProviders, @Nullable SecurityConfiguration securityConfiguration) {
        if (securityConfiguration != null && securityConfiguration.getAuthenticationProviderStrategy() == AuthenticationStrategy.ALL) {
            return this.authenticateAll(requestContext, authenticationRequest, authenticationProviders);
        }
        ArrayList<AuthenticationResponse> responses = new ArrayList<AuthenticationResponse>();
        for (io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?> provider : authenticationProviders) {
            AuthenticationResponse response = this.authenticationResponse(provider, requestContext, authenticationRequest);
            if (response.isAuthenticated()) {
                return response;
            }
            responses.add(response);
        }
        return responses.stream().findFirst().orElseGet(AuthenticationResponse::failure);
    }

    @NonNull
    private AuthenticationResponse authenticateAll(@NonNull T requestContext, @NonNull AuthenticationRequest<?, ?> authenticationRequest, @NonNull List<io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?>> authenticationProviders) {
        List<AuthenticationResponse> authenticationResponses = authenticationProviders.stream().map(provider -> this.authenticationResponse((io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?>)provider, requestContext, authenticationRequest)).toList();
        if (CollectionUtils.isEmpty(authenticationResponses)) {
            return AuthenticationResponse.failure();
        }
        return authenticationResponses.stream().allMatch(AuthenticationResponse::isAuthenticated) ? authenticationResponses.get(0) : AuthenticationResponse.failure();
    }

    private List<ReactiveAuthenticationProvider<T, ?, ?>> everyProviderSorted() {
        ArrayList providers = new ArrayList(this.reactiveAuthenticationProviders);
        if (this.beanContext != null) {
            providers.addAll(this.imperativeAuthenticationProviders.stream().map(imperativeAuthenticationProvider -> {
                if (imperativeAuthenticationProvider instanceof ExecutorAuthenticationProvider) {
                    ExecutorAuthenticationProvider ap = (ExecutorAuthenticationProvider)imperativeAuthenticationProvider;
                    return new AuthenticationProviderAdapter(imperativeAuthenticationProvider, this.executeNameToScheduler.computeIfAbsent(ap.getExecutorName(), s -> this.beanContext.findBean(ExecutorService.class, Qualifiers.byName((String)ap.getExecutorName())).map(Schedulers::fromExecutorService).orElse(null)));
                }
                return new AuthenticationProviderAdapter(imperativeAuthenticationProvider);
            }).toList());
        }
        OrderUtil.sort(providers);
        return providers;
    }

    private Publisher<AuthenticationResponse> authenticate(T request, AuthenticationRequest authenticationRequest, List<ReactiveAuthenticationProvider<T, ?, ?>> providers) {
        if (providers == null) {
            return Flux.empty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(providers.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining()));
        }
        Flux[] emptyArr = new Flux[]{};
        if (this.securityConfiguration != null && this.securityConfiguration.getAuthenticationProviderStrategy() == AuthenticationStrategy.ALL) {
            return Flux.mergeDelayError((int)1, (Publisher[])((Publisher[])providers.stream().map(provider -> Flux.from(provider.authenticate(request, authenticationRequest)).switchMap(rsp -> Authenticator.handleResponse((AuthenticationResponse)rsp)).switchIfEmpty((Publisher)Flux.error(() -> new AuthenticationException("Provider did not respond. Authentication rejected")))).toList().toArray(emptyArr))).last().onErrorResume(t -> Mono.just((Object)Authenticator.authenticationResponseForThrowable(t))).flux();
        }
        AtomicReference lastError = new AtomicReference();
        Flux authentication = Flux.mergeDelayError((int)1, (Publisher[])((Publisher[])providers.stream().map(auth -> Flux.from(auth.authenticate(request, authenticationRequest))).map(sequence -> sequence.switchMap(rsp -> Authenticator.handleResponse((AuthenticationResponse)rsp)).onErrorResume(t -> {
            lastError.set(t);
            return Flux.empty();
        })).toList().toArray(emptyArr)));
        return authentication.take(1L).switchIfEmpty((Publisher)Flux.create(emitter -> {
            Throwable error = (Throwable)lastError.get();
            if (error != null) {
                if (error instanceof AuthenticationException) {
                    AuthenticationResponse response = ((AuthenticationException)error).getResponse();
                    if (response != null) {
                        emitter.next((Object)response);
                        emitter.complete();
                    } else {
                        emitter.error(error);
                    }
                } else {
                    emitter.error(error);
                }
            } else {
                emitter.complete();
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR));
    }

    private static Mono<AuthenticationResponse> handleResponse(AuthenticationResponse response) {
        if (response.isAuthenticated()) {
            return Mono.just((Object)response);
        }
        return Mono.error((Throwable)new AuthenticationException(response));
    }

    @NonNull
    private AuthenticationResponse authenticationResponse(@NonNull io.micronaut.security.authentication.provider.AuthenticationProvider<T, ?, ?> provider, @NonNull T requestContext, @NonNull AuthenticationRequest authenticationRequest) {
        try {
            return provider.authenticate(requestContext, authenticationRequest);
        }
        catch (Exception t) {
            return Authenticator.authenticationResponseForThrowable(t);
        }
    }

    @NonNull
    private static AuthenticationResponse authenticationResponseForThrowable(Throwable t) {
        if (Exceptions.isMultiple((Throwable)t)) {
            List exceptions = Exceptions.unwrapMultiple((Throwable)t);
            return new AuthenticationFailed(((Throwable)exceptions.get(exceptions.size() - 1)).getMessage());
        }
        return new AuthenticationFailed(t.getMessage());
    }
}

