/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.propagation;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.util.OutgoingHttpRequestProcessor;
import io.micronaut.http.util.OutgoingRequestProcessorMatcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.propagation.TokenPropagationConfiguration;
import io.micronaut.security.token.propagation.TokenPropagator;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Filter(value={"${micronaut.security.token.propagation.path:/**}"})
@Requirements(value={@Requires(beans={TokenPropagator.class, TokenPropagationConfiguration.class}), @Requires(property="micronaut.security.token.propagation.enabled", value="true")})
public class TokenPropagationHttpClientFilter
implements HttpClientFilter {
    protected final TokenPropagationConfiguration tokenPropagationConfiguration;
    protected final OutgoingHttpRequestProcessor outgoingHttpRequestProcessor;
    protected final TokenPropagator tokenPropagator;

    public TokenPropagationHttpClientFilter(TokenPropagationConfiguration tokenPropagationConfiguration, OutgoingHttpRequestProcessor outgoingHttpRequestProcessor, TokenPropagator tokenPropagator) {
        this.tokenPropagationConfiguration = tokenPropagationConfiguration;
        this.outgoingHttpRequestProcessor = outgoingHttpRequestProcessor;
        this.tokenPropagator = tokenPropagator;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> targetRequest, ClientFilterChain chain) {
        if (!this.outgoingHttpRequestProcessor.shouldProcessRequest((OutgoingRequestProcessorMatcher)this.tokenPropagationConfiguration, targetRequest)) {
            return chain.proceed(targetRequest);
        }
        Optional current = ServerRequestContext.currentRequest();
        if (current.isPresent()) {
            HttpRequest currentRequest = (HttpRequest)current.get();
            return this.doFilter(targetRequest, chain, (HttpRequest<Object>)currentRequest);
        }
        return chain.proceed(targetRequest);
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> targetRequest, ClientFilterChain chain, HttpRequest<Object> currentRequest) {
        Object obj;
        Optional token = currentRequest.getAttribute(SecurityFilter.TOKEN);
        if (token.isPresent() && (obj = token.get()) instanceof String) {
            String tokenValue = (String)obj;
            if (!this.hasExistingToken(targetRequest)) {
                this.tokenPropagator.writeToken(targetRequest, tokenValue);
            }
            return chain.proceed(targetRequest);
        }
        return chain.proceed(targetRequest);
    }

    private boolean hasExistingToken(MutableHttpRequest<?> targetRequest) {
        return this.tokenPropagator.findToken((HttpRequest<?>)targetRequest).isPresent();
    }
}

