/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.event.TokenValidatedEvent;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.reader.TokenResolver;
import io.micronaut.security.token.validator.TokenValidator;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
public class TokenAuthenticationFetcher
implements AuthenticationFetcher {
    public static final Integer ORDER = 0;
    protected final Collection<TokenValidator> tokenValidators;
    protected final ApplicationEventPublisher<TokenValidatedEvent> tokenValidatedEventPublisher;
    private final TokenResolver tokenResolver;

    public TokenAuthenticationFetcher(Collection<TokenValidator> tokenValidators, TokenResolver tokenResolver, ApplicationEventPublisher<TokenValidatedEvent> tokenValidatedEventPublisher) {
        this.tokenValidatedEventPublisher = tokenValidatedEventPublisher;
        this.tokenResolver = tokenResolver;
        this.tokenValidators = tokenValidators;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        Optional<String> token = this.tokenResolver.resolveToken(request);
        if (!token.isPresent()) {
            return Flux.empty();
        }
        String tokenValue = token.get();
        return Flux.fromIterable(this.tokenValidators).flatMap(tokenValidator -> tokenValidator.validateToken(tokenValue, request)).next().map(authentication -> {
            request.setAttribute(SecurityFilter.TOKEN, (Object)tokenValue);
            this.tokenValidatedEventPublisher.publishEvent((Object)new TokenValidatedEvent(tokenValue));
            return authentication;
        });
    }

    public int getOrder() {
        return ORDER;
    }
}

