/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.ConfigurationInterceptUrlMapRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Singleton
public class SecuredAnnotationRule
extends AbstractSecurityRule {
    public static final Integer ORDER = ConfigurationInterceptUrlMapRule.ORDER - 100;

    public SecuredAnnotationRule(RolesFinder rolesFinder) {
        super(rolesFinder);
    }

    @Override
    public Publisher<SecurityRuleResult> check(HttpRequest<?> request, @Nullable RouteMatch<?> routeMatch, @Nullable Authentication authentication) {
        Optional optionalValue;
        MethodBasedRouteMatch methodRoute;
        if (routeMatch instanceof MethodBasedRouteMatch && (methodRoute = (MethodBasedRouteMatch)routeMatch).hasAnnotation(Secured.class) && (optionalValue = methodRoute.getValue(Secured.class, String[].class)).isPresent()) {
            List<String> values = Arrays.asList((String[])optionalValue.get());
            if (values.contains("denyAll()")) {
                return Mono.just((Object)((Object)SecurityRuleResult.REJECTED));
            }
            return this.compareRoles(values, this.getRoles(authentication));
        }
        return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
    }

    public int getOrder() {
        return ORDER;
    }
}

